package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataArchiveCount invokes the dms_enterprise.GetDataArchiveCount API synchronously
func (client *Client) GetDataArchiveCount(request *GetDataArchiveCountRequest) (response *GetDataArchiveCountResponse, err error) {
	response = CreateGetDataArchiveCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataArchiveCountWithChan invokes the dms_enterprise.GetDataArchiveCount API asynchronously
func (client *Client) GetDataArchiveCountWithChan(request *GetDataArchiveCountRequest) (<-chan *GetDataArchiveCountResponse, <-chan error) {
	responseChan := make(chan *GetDataArchiveCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataArchiveCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataArchiveCountWithCallback invokes the dms_enterprise.GetDataArchiveCount API asynchronously
func (client *Client) GetDataArchiveCountWithCallback(request *GetDataArchiveCountRequest, callback func(response *GetDataArchiveCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataArchiveCountResponse
		var err error
		defer close(result)
		response, err = client.GetDataArchiveCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataArchiveCountRequest is the request struct for api GetDataArchiveCount
type GetDataArchiveCountRequest struct {
	*requests.RpcRequest
	SearchDateType  string           `position:"Query" name:"SearchDateType"`
	Tid             requests.Integer `position:"Query" name:"Tid"`
	PluginType      string           `position:"Query" name:"PluginType"`
	OrderResultType string           `position:"Query" name:"OrderResultType"`
}

// GetDataArchiveCountResponse is the response struct for api GetDataArchiveCount
type GetDataArchiveCountResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDataArchiveCountRequest creates a request to invoke GetDataArchiveCount API
func CreateGetDataArchiveCountRequest() (request *GetDataArchiveCountRequest) {
	request = &GetDataArchiveCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataArchiveCount", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataArchiveCountResponse creates a response to parse from GetDataArchiveCount response
func CreateGetDataArchiveCountResponse() (response *GetDataArchiveCountResponse) {
	response = &GetDataArchiveCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
