package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantTemplateAuthority invokes the dms_enterprise.GrantTemplateAuthority API synchronously
func (client *Client) GrantTemplateAuthority(request *GrantTemplateAuthorityRequest) (response *GrantTemplateAuthorityResponse, err error) {
	response = CreateGrantTemplateAuthorityResponse()
	err = client.DoAction(request, response)
	return
}

// GrantTemplateAuthorityWithChan invokes the dms_enterprise.GrantTemplateAuthority API asynchronously
func (client *Client) GrantTemplateAuthorityWithChan(request *GrantTemplateAuthorityRequest) (<-chan *GrantTemplateAuthorityResponse, <-chan error) {
	responseChan := make(chan *GrantTemplateAuthorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantTemplateAuthority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantTemplateAuthorityWithCallback invokes the dms_enterprise.GrantTemplateAuthority API asynchronously
func (client *Client) GrantTemplateAuthorityWithCallback(request *GrantTemplateAuthorityRequest, callback func(response *GrantTemplateAuthorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantTemplateAuthorityResponse
		var err error
		defer close(result)
		response, err = client.GrantTemplateAuthority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantTemplateAuthorityRequest is the request struct for api GrantTemplateAuthority
type GrantTemplateAuthorityRequest struct {
	*requests.RpcRequest
	ExpireDate string           `position:"Query" name:"ExpireDate"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	TemplateId requests.Integer `position:"Query" name:"TemplateId"`
	UserIds    string           `position:"Query" name:"UserIds"`
	Comment    string           `position:"Query" name:"Comment"`
}

// GrantTemplateAuthorityResponse is the response struct for api GrantTemplateAuthority
type GrantTemplateAuthorityResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Result       bool   `json:"Result" xml:"Result"`
}

// CreateGrantTemplateAuthorityRequest creates a request to invoke GrantTemplateAuthority API
func CreateGrantTemplateAuthorityRequest() (request *GrantTemplateAuthorityRequest) {
	request = &GrantTemplateAuthorityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GrantTemplateAuthority", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGrantTemplateAuthorityResponse creates a response to parse from GrantTemplateAuthority response
func CreateGrantTemplateAuthorityResponse() (response *GrantTemplateAuthorityResponse) {
	response = &GrantTemplateAuthorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
