package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDataTrackResultDownloadStatus invokes the dms_enterprise.QueryDataTrackResultDownloadStatus API synchronously
func (client *Client) QueryDataTrackResultDownloadStatus(request *QueryDataTrackResultDownloadStatusRequest) (response *QueryDataTrackResultDownloadStatusResponse, err error) {
	response = CreateQueryDataTrackResultDownloadStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDataTrackResultDownloadStatusWithChan invokes the dms_enterprise.QueryDataTrackResultDownloadStatus API asynchronously
func (client *Client) QueryDataTrackResultDownloadStatusWithChan(request *QueryDataTrackResultDownloadStatusRequest) (<-chan *QueryDataTrackResultDownloadStatusResponse, <-chan error) {
	responseChan := make(chan *QueryDataTrackResultDownloadStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDataTrackResultDownloadStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDataTrackResultDownloadStatusWithCallback invokes the dms_enterprise.QueryDataTrackResultDownloadStatus API asynchronously
func (client *Client) QueryDataTrackResultDownloadStatusWithCallback(request *QueryDataTrackResultDownloadStatusRequest, callback func(response *QueryDataTrackResultDownloadStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDataTrackResultDownloadStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryDataTrackResultDownloadStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDataTrackResultDownloadStatusRequest is the request struct for api QueryDataTrackResultDownloadStatus
type QueryDataTrackResultDownloadStatusRequest struct {
	*requests.RpcRequest
	Tid           requests.Integer `position:"Query" name:"Tid"`
	OrderId       requests.Integer `position:"Query" name:"OrderId"`
	DownloadKeyId string           `position:"Query" name:"DownloadKeyId"`
}

// QueryDataTrackResultDownloadStatusResponse is the response struct for api QueryDataTrackResultDownloadStatus
type QueryDataTrackResultDownloadStatusResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	StatusResult StatusResult `json:"StatusResult" xml:"StatusResult"`
}

// CreateQueryDataTrackResultDownloadStatusRequest creates a request to invoke QueryDataTrackResultDownloadStatus API
func CreateQueryDataTrackResultDownloadStatusRequest() (request *QueryDataTrackResultDownloadStatusRequest) {
	request = &QueryDataTrackResultDownloadStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "QueryDataTrackResultDownloadStatus", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDataTrackResultDownloadStatusResponse creates a response to parse from QueryDataTrackResultDownloadStatus response
func CreateQueryDataTrackResultDownloadStatusResponse() (response *QueryDataTrackResultDownloadStatusResponse) {
	response = &QueryDataTrackResultDownloadStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
