package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskFlowCooperators invokes the dms_enterprise.UpdateTaskFlowCooperators API synchronously
func (client *Client) UpdateTaskFlowCooperators(request *UpdateTaskFlowCooperatorsRequest) (response *UpdateTaskFlowCooperatorsResponse, err error) {
	response = CreateUpdateTaskFlowCooperatorsResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskFlowCooperatorsWithChan invokes the dms_enterprise.UpdateTaskFlowCooperators API asynchronously
func (client *Client) UpdateTaskFlowCooperatorsWithChan(request *UpdateTaskFlowCooperatorsRequest) (<-chan *UpdateTaskFlowCooperatorsResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskFlowCooperatorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskFlowCooperators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskFlowCooperatorsWithCallback invokes the dms_enterprise.UpdateTaskFlowCooperators API asynchronously
func (client *Client) UpdateTaskFlowCooperatorsWithCallback(request *UpdateTaskFlowCooperatorsRequest, callback func(response *UpdateTaskFlowCooperatorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskFlowCooperatorsResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskFlowCooperators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskFlowCooperatorsRequest is the request struct for api UpdateTaskFlowCooperators
type UpdateTaskFlowCooperatorsRequest struct {
	*requests.RpcRequest
	DagId         requests.Integer `position:"Query" name:"DagId"`
	Tid           requests.Integer `position:"Query" name:"Tid"`
	CooperatorIds *[]string        `position:"Query" name:"CooperatorIds"  type:"Json"`
}

// UpdateTaskFlowCooperatorsResponse is the response struct for api UpdateTaskFlowCooperators
type UpdateTaskFlowCooperatorsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskFlowCooperatorsRequest creates a request to invoke UpdateTaskFlowCooperators API
func CreateUpdateTaskFlowCooperatorsRequest() (request *UpdateTaskFlowCooperatorsRequest) {
	request = &UpdateTaskFlowCooperatorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskFlowCooperators", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskFlowCooperatorsResponse creates a response to parse from UpdateTaskFlowCooperators response
func CreateUpdateTaskFlowCooperatorsResponse() (response *UpdateTaskFlowCooperatorsResponse) {
	response = &UpdateTaskFlowCooperatorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
