package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyEmail invokes the domain.VerifyEmail API synchronously
func (client *Client) VerifyEmail(request *VerifyEmailRequest) (response *VerifyEmailResponse, err error) {
	response = CreateVerifyEmailResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyEmailWithChan invokes the domain.VerifyEmail API asynchronously
func (client *Client) VerifyEmailWithChan(request *VerifyEmailRequest) (<-chan *VerifyEmailResponse, <-chan error) {
	responseChan := make(chan *VerifyEmailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyEmail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyEmailWithCallback invokes the domain.VerifyEmail API asynchronously
func (client *Client) VerifyEmailWithCallback(request *VerifyEmailRequest, callback func(response *VerifyEmailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyEmailResponse
		var err error
		defer close(result)
		response, err = client.VerifyEmail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyEmailRequest is the request struct for api VerifyEmail
type VerifyEmailRequest struct {
	*requests.RpcRequest
	Token        string `position:"Query" name:"Token"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// VerifyEmailResponse is the response struct for api VerifyEmail
type VerifyEmailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyEmailRequest creates a request to invoke VerifyEmail API
func CreateVerifyEmailRequest() (request *VerifyEmailRequest) {
	request = &VerifyEmailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "VerifyEmail", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVerifyEmailResponse creates a response to parse from VerifyEmail response
func CreateVerifyEmailResponse() (response *VerifyEmailResponse) {
	response = &VerifyEmailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
