package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsShardingDbs invokes the drds.DescribeDrdsShardingDbs API synchronously
func (client *Client) DescribeDrdsShardingDbs(request *DescribeDrdsShardingDbsRequest) (response *DescribeDrdsShardingDbsResponse, err error) {
	response = CreateDescribeDrdsShardingDbsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsShardingDbsWithChan invokes the drds.DescribeDrdsShardingDbs API asynchronously
func (client *Client) DescribeDrdsShardingDbsWithChan(request *DescribeDrdsShardingDbsRequest) (<-chan *DescribeDrdsShardingDbsResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsShardingDbsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsShardingDbs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsShardingDbsWithCallback invokes the drds.DescribeDrdsShardingDbs API asynchronously
func (client *Client) DescribeDrdsShardingDbsWithCallback(request *DescribeDrdsShardingDbsRequest, callback func(response *DescribeDrdsShardingDbsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsShardingDbsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsShardingDbs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsShardingDbsRequest is the request struct for api DescribeDrdsShardingDbs
type DescribeDrdsShardingDbsRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	DbName         string           `position:"Query" name:"DbName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	DbNamePattern  string           `position:"Query" name:"DbNamePattern"`
}

// DescribeDrdsShardingDbsResponse is the response struct for api DescribeDrdsShardingDbs
type DescribeDrdsShardingDbsResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  string      `json:"PageNumber" xml:"PageNumber"`
	PageSize    string      `json:"PageSize" xml:"PageSize"`
	Total       string      `json:"Total" xml:"Total"`
	ShardingDbs ShardingDbs `json:"ShardingDbs" xml:"ShardingDbs"`
}

// CreateDescribeDrdsShardingDbsRequest creates a request to invoke DescribeDrdsShardingDbs API
func CreateDescribeDrdsShardingDbsRequest() (request *DescribeDrdsShardingDbsRequest) {
	request = &DescribeDrdsShardingDbsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDrdsShardingDbs", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDrdsShardingDbsResponse creates a response to parse from DescribeDrdsShardingDbs response
func CreateDescribeDrdsShardingDbsResponse() (response *DescribeDrdsShardingDbsResponse) {
	response = &DescribeDrdsShardingDbsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
