package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVerifyScheme invokes the dypnsapi.DeleteVerifyScheme API synchronously
func (client *Client) DeleteVerifyScheme(request *DeleteVerifySchemeRequest) (response *DeleteVerifySchemeResponse, err error) {
	response = CreateDeleteVerifySchemeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVerifySchemeWithChan invokes the dypnsapi.DeleteVerifyScheme API asynchronously
func (client *Client) DeleteVerifySchemeWithChan(request *DeleteVerifySchemeRequest) (<-chan *DeleteVerifySchemeResponse, <-chan error) {
	responseChan := make(chan *DeleteVerifySchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVerifyScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVerifySchemeWithCallback invokes the dypnsapi.DeleteVerifyScheme API asynchronously
func (client *Client) DeleteVerifySchemeWithCallback(request *DeleteVerifySchemeRequest, callback func(response *DeleteVerifySchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVerifySchemeResponse
		var err error
		defer close(result)
		response, err = client.DeleteVerifyScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVerifySchemeRequest is the request struct for api DeleteVerifyScheme
type DeleteVerifySchemeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SchemeCode           string           `position:"Query" name:"SchemeCode"`
	CustomerId           requests.Integer `position:"Query" name:"CustomerId"`
}

// DeleteVerifySchemeResponse is the response struct for api DeleteVerifyScheme
type DeleteVerifySchemeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateDeleteVerifySchemeRequest creates a request to invoke DeleteVerifyScheme API
func CreateDeleteVerifySchemeRequest() (request *DeleteVerifySchemeRequest) {
	request = &DeleteVerifySchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "DeleteVerifyScheme", "dypnsapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVerifySchemeResponse creates a response to parse from DeleteVerifyScheme response
func CreateDeleteVerifySchemeResponse() (response *DeleteVerifySchemeResponse) {
	response = &DeleteVerifySchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
