package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JyQueryAppInfoBySceneCode invokes the dypnsapi.JyQueryAppInfoBySceneCode API synchronously
func (client *Client) JyQueryAppInfoBySceneCode(request *JyQueryAppInfoBySceneCodeRequest) (response *JyQueryAppInfoBySceneCodeResponse, err error) {
	response = CreateJyQueryAppInfoBySceneCodeResponse()
	err = client.DoAction(request, response)
	return
}

// JyQueryAppInfoBySceneCodeWithChan invokes the dypnsapi.JyQueryAppInfoBySceneCode API asynchronously
func (client *Client) JyQueryAppInfoBySceneCodeWithChan(request *JyQueryAppInfoBySceneCodeRequest) (<-chan *JyQueryAppInfoBySceneCodeResponse, <-chan error) {
	responseChan := make(chan *JyQueryAppInfoBySceneCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JyQueryAppInfoBySceneCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JyQueryAppInfoBySceneCodeWithCallback invokes the dypnsapi.JyQueryAppInfoBySceneCode API asynchronously
func (client *Client) JyQueryAppInfoBySceneCodeWithCallback(request *JyQueryAppInfoBySceneCodeRequest, callback func(response *JyQueryAppInfoBySceneCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JyQueryAppInfoBySceneCodeResponse
		var err error
		defer close(result)
		response, err = client.JyQueryAppInfoBySceneCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JyQueryAppInfoBySceneCodeRequest is the request struct for api JyQueryAppInfoBySceneCode
type JyQueryAppInfoBySceneCodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SceneCode            string           `position:"Query" name:"SceneCode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// JyQueryAppInfoBySceneCodeResponse is the response struct for api JyQueryAppInfoBySceneCode
type JyQueryAppInfoBySceneCodeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateJyQueryAppInfoBySceneCodeRequest creates a request to invoke JyQueryAppInfoBySceneCode API
func CreateJyQueryAppInfoBySceneCodeRequest() (request *JyQueryAppInfoBySceneCodeRequest) {
	request = &JyQueryAppInfoBySceneCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "JyQueryAppInfoBySceneCode", "dypnsapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateJyQueryAppInfoBySceneCodeResponse creates a response to parse from JyQueryAppInfoBySceneCode response
func CreateJyQueryAppInfoBySceneCodeResponse() (response *JyQueryAppInfoBySceneCodeResponse) {
	response = &JyQueryAppInfoBySceneCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
