package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateExtCodeSign invokes the dysmsapi.UpdateExtCodeSign API synchronously
func (client *Client) UpdateExtCodeSign(request *UpdateExtCodeSignRequest) (response *UpdateExtCodeSignResponse, err error) {
	response = CreateUpdateExtCodeSignResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateExtCodeSignWithChan invokes the dysmsapi.UpdateExtCodeSign API asynchronously
func (client *Client) UpdateExtCodeSignWithChan(request *UpdateExtCodeSignRequest) (<-chan *UpdateExtCodeSignResponse, <-chan error) {
	responseChan := make(chan *UpdateExtCodeSignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateExtCodeSign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateExtCodeSignWithCallback invokes the dysmsapi.UpdateExtCodeSign API asynchronously
func (client *Client) UpdateExtCodeSignWithCallback(request *UpdateExtCodeSignRequest, callback func(response *UpdateExtCodeSignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateExtCodeSignResponse
		var err error
		defer close(result)
		response, err = client.UpdateExtCodeSign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateExtCodeSignRequest is the request struct for api UpdateExtCodeSign
type UpdateExtCodeSignRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NewExtCode           string           `position:"Query" name:"NewExtCode"`
	LowcodeTenantId      string           `position:"Query" name:"LowcodeTenantId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	LowcodePhysicAppName string           `position:"Query" name:"LowcodePhysicAppName"`
	SignName             string           `position:"Query" name:"SignName"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ExistExtCode         string           `position:"Query" name:"ExistExtCode"`
	LowcodeLogicAppName  string           `position:"Query" name:"LowcodeLogicAppName"`
}

// UpdateExtCodeSignResponse is the response struct for api UpdateExtCodeSign
type UpdateExtCodeSignResponse struct {
	*responses.BaseResponse
	AccessDeniedDetail string `json:"AccessDeniedDetail" xml:"AccessDeniedDetail"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Message            string `json:"Message" xml:"Message"`
	Data               bool   `json:"Data" xml:"Data"`
	Code               string `json:"Code" xml:"Code"`
	Success            bool   `json:"Success" xml:"Success"`
}

// CreateUpdateExtCodeSignRequest creates a request to invoke UpdateExtCodeSign API
func CreateUpdateExtCodeSignRequest() (request *UpdateExtCodeSignRequest) {
	request = &UpdateExtCodeSignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "UpdateExtCodeSign", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateExtCodeSignResponse creates a response to parse from UpdateExtCodeSign response
func CreateUpdateExtCodeSignResponse() (response *UpdateExtCodeSignResponse) {
	response = &UpdateExtCodeSignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
