package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReprotectDiskReplicaPair invokes the ebs.ReprotectDiskReplicaPair API synchronously
func (client *Client) ReprotectDiskReplicaPair(request *ReprotectDiskReplicaPairRequest) (response *ReprotectDiskReplicaPairResponse, err error) {
	response = CreateReprotectDiskReplicaPairResponse()
	err = client.DoAction(request, response)
	return
}

// ReprotectDiskReplicaPairWithChan invokes the ebs.ReprotectDiskReplicaPair API asynchronously
func (client *Client) ReprotectDiskReplicaPairWithChan(request *ReprotectDiskReplicaPairRequest) (<-chan *ReprotectDiskReplicaPairResponse, <-chan error) {
	responseChan := make(chan *ReprotectDiskReplicaPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReprotectDiskReplicaPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReprotectDiskReplicaPairWithCallback invokes the ebs.ReprotectDiskReplicaPair API asynchronously
func (client *Client) ReprotectDiskReplicaPairWithCallback(request *ReprotectDiskReplicaPairRequest, callback func(response *ReprotectDiskReplicaPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReprotectDiskReplicaPairResponse
		var err error
		defer close(result)
		response, err = client.ReprotectDiskReplicaPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReprotectDiskReplicaPairRequest is the request struct for api ReprotectDiskReplicaPair
type ReprotectDiskReplicaPairRequest struct {
	*requests.RpcRequest
	ClientToken   string `position:"Query" name:"ClientToken"`
	ReplicaPairId string `position:"Query" name:"ReplicaPairId"`
}

// ReprotectDiskReplicaPairResponse is the response struct for api ReprotectDiskReplicaPair
type ReprotectDiskReplicaPairResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReprotectDiskReplicaPairRequest creates a request to invoke ReprotectDiskReplicaPair API
func CreateReprotectDiskReplicaPairRequest() (request *ReprotectDiskReplicaPairRequest) {
	request = &ReprotectDiskReplicaPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "ReprotectDiskReplicaPair", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReprotectDiskReplicaPairResponse creates a response to parse from ReprotectDiskReplicaPair response
func CreateReprotectDiskReplicaPairResponse() (response *ReprotectDiskReplicaPairResponse) {
	response = &ReprotectDiskReplicaPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
