package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CopyCdsFile invokes the ecd.CopyCdsFile API synchronously
func (client *Client) CopyCdsFile(request *CopyCdsFileRequest) (response *CopyCdsFileResponse, err error) {
	response = CreateCopyCdsFileResponse()
	err = client.DoAction(request, response)
	return
}

// CopyCdsFileWithChan invokes the ecd.CopyCdsFile API asynchronously
func (client *Client) CopyCdsFileWithChan(request *CopyCdsFileRequest) (<-chan *CopyCdsFileResponse, <-chan error) {
	responseChan := make(chan *CopyCdsFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CopyCdsFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CopyCdsFileWithCallback invokes the ecd.CopyCdsFile API asynchronously
func (client *Client) CopyCdsFileWithCallback(request *CopyCdsFileRequest, callback func(response *CopyCdsFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CopyCdsFileResponse
		var err error
		defer close(result)
		response, err = client.CopyCdsFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CopyCdsFileRequest is the request struct for api CopyCdsFile
type CopyCdsFileRequest struct {
	*requests.RpcRequest
	FileReceiverId   string           `position:"Query" name:"FileReceiverId"`
	GroupId          string           `position:"Query" name:"GroupId"`
	FileReceiverType string           `position:"Query" name:"FileReceiverType"`
	AutoRename       requests.Boolean `position:"Query" name:"AutoRename"`
	CdsId            string           `position:"Query" name:"CdsId"`
	ParentFolderId   string           `position:"Query" name:"ParentFolderId"`
	EndUserId        string           `position:"Query" name:"EndUserId"`
	FileId           string           `position:"Query" name:"FileId"`
}

// CopyCdsFileResponse is the response struct for api CopyCdsFile
type CopyCdsFileResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Code             string           `json:"Code" xml:"Code"`
	Message          string           `json:"Message" xml:"Message"`
	Success          string           `json:"Success" xml:"Success"`
	CopyCdsFileModel CopyCdsFileModel `json:"CopyCdsFileModel" xml:"CopyCdsFileModel"`
}

// CreateCopyCdsFileRequest creates a request to invoke CopyCdsFile API
func CreateCopyCdsFileRequest() (request *CopyCdsFileRequest) {
	request = &CopyCdsFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CopyCdsFile", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCopyCdsFileResponse creates a response to parse from CopyCdsFile response
func CreateCopyCdsFileResponse() (response *CopyCdsFileResponse) {
	response = &CopyCdsFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
