package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopSessions invokes the ecd.DescribeDesktopSessions API synchronously
func (client *Client) DescribeDesktopSessions(request *DescribeDesktopSessionsRequest) (response *DescribeDesktopSessionsResponse, err error) {
	response = CreateDescribeDesktopSessionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopSessionsWithChan invokes the ecd.DescribeDesktopSessions API asynchronously
func (client *Client) DescribeDesktopSessionsWithChan(request *DescribeDesktopSessionsRequest) (<-chan *DescribeDesktopSessionsResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopSessionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopSessions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopSessionsWithCallback invokes the ecd.DescribeDesktopSessions API asynchronously
func (client *Client) DescribeDesktopSessionsWithCallback(request *DescribeDesktopSessionsRequest, callback func(response *DescribeDesktopSessionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopSessionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopSessions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopSessionsRequest is the request struct for api DescribeDesktopSessions
type DescribeDesktopSessionsRequest struct {
	*requests.RpcRequest
	OfficeSiteId   string           `position:"Query" name:"OfficeSiteId"`
	StartTime      string           `position:"Query" name:"StartTime"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	SessionStatus  string           `position:"Query" name:"SessionStatus"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	EndUserId      string           `position:"Query" name:"EndUserId"`
	DesktopId      *[]string        `position:"Query" name:"DesktopId"  type:"Repeated"`
	DesktopName    string           `position:"Query" name:"DesktopName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	SubPayType     string           `position:"Query" name:"SubPayType"`
	CheckOsSession requests.Boolean `position:"Query" name:"CheckOsSession"`
}

// DescribeDesktopSessionsResponse is the response struct for api DescribeDesktopSessions
type DescribeDesktopSessionsResponse struct {
	*responses.BaseResponse
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	Sessions   []Session `json:"Sessions" xml:"Sessions"`
}

// CreateDescribeDesktopSessionsRequest creates a request to invoke DescribeDesktopSessions API
func CreateDescribeDesktopSessionsRequest() (request *DescribeDesktopSessionsRequest) {
	request = &DescribeDesktopSessionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopSessions", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopSessionsResponse creates a response to parse from DescribeDesktopSessions response
func CreateDescribeDesktopSessionsResponse() (response *DescribeDesktopSessionsResponse) {
	response = &DescribeDesktopSessionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
