package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserProfilePathRules invokes the ecd.DescribeUserProfilePathRules API synchronously
func (client *Client) DescribeUserProfilePathRules(request *DescribeUserProfilePathRulesRequest) (response *DescribeUserProfilePathRulesResponse, err error) {
	response = CreateDescribeUserProfilePathRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserProfilePathRulesWithChan invokes the ecd.DescribeUserProfilePathRules API asynchronously
func (client *Client) DescribeUserProfilePathRulesWithChan(request *DescribeUserProfilePathRulesRequest) (<-chan *DescribeUserProfilePathRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeUserProfilePathRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserProfilePathRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserProfilePathRulesWithCallback invokes the ecd.DescribeUserProfilePathRules API asynchronously
func (client *Client) DescribeUserProfilePathRulesWithCallback(request *DescribeUserProfilePathRulesRequest, callback func(response *DescribeUserProfilePathRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserProfilePathRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserProfilePathRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserProfilePathRulesRequest is the request struct for api DescribeUserProfilePathRules
type DescribeUserProfilePathRulesRequest struct {
	*requests.RpcRequest
	RuleType       string `position:"Query" name:"RuleType"`
	DesktopGroupId string `position:"Query" name:"DesktopGroupId"`
}

// DescribeUserProfilePathRulesResponse is the response struct for api DescribeUserProfilePathRules
type DescribeUserProfilePathRulesResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	UserProfilePathRule UserProfilePathRule `json:"UserProfilePathRule" xml:"UserProfilePathRule"`
}

// CreateDescribeUserProfilePathRulesRequest creates a request to invoke DescribeUserProfilePathRules API
func CreateDescribeUserProfilePathRulesRequest() (request *DescribeUserProfilePathRulesRequest) {
	request = &DescribeUserProfilePathRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeUserProfilePathRules", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserProfilePathRulesResponse creates a response to parse from DescribeUserProfilePathRules response
func CreateDescribeUserProfilePathRulesResponse() (response *DescribeUserProfilePathRulesResponse) {
	response = &DescribeUserProfilePathRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
