package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncTask invokes the ecd.GetAsyncTask API synchronously
func (client *Client) GetAsyncTask(request *GetAsyncTaskRequest) (response *GetAsyncTaskResponse, err error) {
	response = CreateGetAsyncTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncTaskWithChan invokes the ecd.GetAsyncTask API asynchronously
func (client *Client) GetAsyncTaskWithChan(request *GetAsyncTaskRequest) (<-chan *GetAsyncTaskResponse, <-chan error) {
	responseChan := make(chan *GetAsyncTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncTaskWithCallback invokes the ecd.GetAsyncTask API asynchronously
func (client *Client) GetAsyncTaskWithCallback(request *GetAsyncTaskRequest, callback func(response *GetAsyncTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncTaskResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncTaskRequest is the request struct for api GetAsyncTask
type GetAsyncTaskRequest struct {
	*requests.RpcRequest
	CdsId       string `position:"Query" name:"CdsId"`
	AsyncTaskId string `position:"Query" name:"AsyncTaskId"`
}

// GetAsyncTaskResponse is the response struct for api GetAsyncTask
type GetAsyncTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetAsyncTaskRequest creates a request to invoke GetAsyncTask API
func CreateGetAsyncTaskRequest() (request *GetAsyncTaskRequest) {
	request = &GetAsyncTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "GetAsyncTask", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAsyncTaskResponse creates a response to parse from GetAsyncTask response
func CreateGetAsyncTaskResponse() (response *GetAsyncTaskResponse) {
	response = &GetAsyncTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
