package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyImagePermission invokes the ecd.ModifyImagePermission API synchronously
func (client *Client) ModifyImagePermission(request *ModifyImagePermissionRequest) (response *ModifyImagePermissionResponse, err error) {
	response = CreateModifyImagePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyImagePermissionWithChan invokes the ecd.ModifyImagePermission API asynchronously
func (client *Client) ModifyImagePermissionWithChan(request *ModifyImagePermissionRequest) (<-chan *ModifyImagePermissionResponse, <-chan error) {
	responseChan := make(chan *ModifyImagePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyImagePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyImagePermissionWithCallback invokes the ecd.ModifyImagePermission API asynchronously
func (client *Client) ModifyImagePermissionWithCallback(request *ModifyImagePermissionRequest, callback func(response *ModifyImagePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyImagePermissionResponse
		var err error
		defer close(result)
		response, err = client.ModifyImagePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyImagePermissionRequest is the request struct for api ModifyImagePermission
type ModifyImagePermissionRequest struct {
	*requests.RpcRequest
	ImageId       string    `position:"Query" name:"ImageId"`
	AddAccount    *[]string `position:"Query" name:"AddAccount"  type:"Repeated"`
	RemoveAccount *[]string `position:"Query" name:"RemoveAccount"  type:"Repeated"`
}

// ModifyImagePermissionResponse is the response struct for api ModifyImagePermission
type ModifyImagePermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyImagePermissionRequest creates a request to invoke ModifyImagePermission API
func CreateModifyImagePermissionRequest() (request *ModifyImagePermissionRequest) {
	request = &ModifyImagePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyImagePermission", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyImagePermissionResponse creates a response to parse from ModifyImagePermission response
func CreateModifyImagePermissionResponse() (response *ModifyImagePermissionResponse) {
	response = &ModifyImagePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
