package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDesktopMaintenance invokes the ecd.SetDesktopMaintenance API synchronously
func (client *Client) SetDesktopMaintenance(request *SetDesktopMaintenanceRequest) (response *SetDesktopMaintenanceResponse, err error) {
	response = CreateSetDesktopMaintenanceResponse()
	err = client.DoAction(request, response)
	return
}

// SetDesktopMaintenanceWithChan invokes the ecd.SetDesktopMaintenance API asynchronously
func (client *Client) SetDesktopMaintenanceWithChan(request *SetDesktopMaintenanceRequest) (<-chan *SetDesktopMaintenanceResponse, <-chan error) {
	responseChan := make(chan *SetDesktopMaintenanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDesktopMaintenance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDesktopMaintenanceWithCallback invokes the ecd.SetDesktopMaintenance API asynchronously
func (client *Client) SetDesktopMaintenanceWithCallback(request *SetDesktopMaintenanceRequest, callback func(response *SetDesktopMaintenanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDesktopMaintenanceResponse
		var err error
		defer close(result)
		response, err = client.SetDesktopMaintenance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDesktopMaintenanceRequest is the request struct for api SetDesktopMaintenance
type SetDesktopMaintenanceRequest struct {
	*requests.RpcRequest
	DesktopIds *[]string `position:"Query" name:"DesktopIds"  type:"Repeated"`
	Mode       string    `position:"Query" name:"Mode"`
}

// SetDesktopMaintenanceResponse is the response struct for api SetDesktopMaintenance
type SetDesktopMaintenanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDesktopMaintenanceRequest creates a request to invoke SetDesktopMaintenance API
func CreateSetDesktopMaintenanceRequest() (request *SetDesktopMaintenanceRequest) {
	request = &SetDesktopMaintenanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "SetDesktopMaintenance", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDesktopMaintenanceResponse creates a response to parse from SetDesktopMaintenance response
func CreateSetDesktopMaintenanceResponse() (response *SetDesktopMaintenanceResponse) {
	response = &SetDesktopMaintenanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
