package ecs_workbench

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceRecordConfig invokes the ecs_workbench.GetInstanceRecordConfig API synchronously
func (client *Client) GetInstanceRecordConfig(request *GetInstanceRecordConfigRequest) (response *GetInstanceRecordConfigResponse, err error) {
	response = CreateGetInstanceRecordConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceRecordConfigWithChan invokes the ecs_workbench.GetInstanceRecordConfig API asynchronously
func (client *Client) GetInstanceRecordConfigWithChan(request *GetInstanceRecordConfigRequest) (<-chan *GetInstanceRecordConfigResponse, <-chan error) {
	responseChan := make(chan *GetInstanceRecordConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceRecordConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceRecordConfigWithCallback invokes the ecs_workbench.GetInstanceRecordConfig API asynchronously
func (client *Client) GetInstanceRecordConfigWithCallback(request *GetInstanceRecordConfigRequest, callback func(response *GetInstanceRecordConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceRecordConfigResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceRecordConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceRecordConfigRequest is the request struct for api GetInstanceRecordConfig
type GetInstanceRecordConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
}

// GetInstanceRecordConfigResponse is the response struct for api GetInstanceRecordConfig
type GetInstanceRecordConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Root      Root   `json:"Root" xml:"Root"`
}

// CreateGetInstanceRecordConfigRequest creates a request to invoke GetInstanceRecordConfig API
func CreateGetInstanceRecordConfigRequest() (request *GetInstanceRecordConfigRequest) {
	request = &GetInstanceRecordConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecs-workbench", "2022-02-20", "GetInstanceRecordConfig", "ecs-workbench", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceRecordConfigResponse creates a response to parse from GetInstanceRecordConfig response
func CreateGetInstanceRecordConfigResponse() (response *GetInstanceRecordConfigResponse) {
	response = &GetInstanceRecordConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
