package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateImagePipeline invokes the ecs.CreateImagePipeline API synchronously
func (client *Client) CreateImagePipeline(request *CreateImagePipelineRequest) (response *CreateImagePipelineResponse, err error) {
	response = CreateCreateImagePipelineResponse()
	err = client.DoAction(request, response)
	return
}

// CreateImagePipelineWithChan invokes the ecs.CreateImagePipeline API asynchronously
func (client *Client) CreateImagePipelineWithChan(request *CreateImagePipelineRequest) (<-chan *CreateImagePipelineResponse, <-chan error) {
	responseChan := make(chan *CreateImagePipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateImagePipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateImagePipelineWithCallback invokes the ecs.CreateImagePipeline API asynchronously
func (client *Client) CreateImagePipelineWithCallback(request *CreateImagePipelineRequest, callback func(response *CreateImagePipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateImagePipelineResponse
		var err error
		defer close(result)
		response, err = client.CreateImagePipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateImagePipelineRequest is the request struct for api CreateImagePipeline
type CreateImagePipelineRequest struct {
	*requests.RpcRequest
	BaseImageType           string                                `position:"Query" name:"BaseImageType"`
	ResourceOwnerId         requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId         string                                `position:"Query" name:"ResourceGroupId"`
	ImageOptions            CreateImagePipelineImageOptions       `position:"Query" name:"ImageOptions"  type:"Struct"`
	SystemDiskSize          requests.Integer                      `position:"Query" name:"SystemDiskSize"`
	Tag                     *[]CreateImagePipelineTag             `position:"Query" name:"Tag"  type:"Repeated"`
	AdvancedOptions         CreateImagePipelineAdvancedOptions    `position:"Query" name:"AdvancedOptions"  type:"Struct"`
	RepairMode              string                                `position:"Query" name:"RepairMode"`
	OwnerId                 requests.Integer                      `position:"Query" name:"OwnerId"`
	VSwitchId               string                                `position:"Query" name:"VSwitchId"`
	AddAccount              *[]string                             `position:"Query" name:"AddAccount"  type:"Repeated"`
	DeleteInstanceOnFailure requests.Boolean                      `position:"Query" name:"DeleteInstanceOnFailure"`
	Name                    string                                `position:"Query" name:"Name"`
	ImportImageOptions      CreateImagePipelineImportImageOptions `position:"Query" name:"ImportImageOptions"  type:"Struct"`
	TestContent             string                                `position:"Query" name:"TestContent"`
	ClientToken             string                                `position:"Query" name:"ClientToken"`
	ToRegionId              *[]string                             `position:"Query" name:"ToRegionId"  type:"Repeated"`
	InternetMaxBandwidthOut requests.Integer                      `position:"Query" name:"InternetMaxBandwidthOut"`
	Description             string                                `position:"Query" name:"Description"`
	ImageName               string                                `position:"Query" name:"ImageName"`
	InstanceType            string                                `position:"Query" name:"InstanceType"`
	NvmeSupport             string                                `position:"Query" name:"NvmeSupport"`
	ResourceOwnerAccount    string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string                                `position:"Query" name:"OwnerAccount"`
	BaseImage               string                                `position:"Query" name:"BaseImage"`
	ImageFamily             string                                `position:"Query" name:"ImageFamily"`
	BuildContent            string                                `position:"Query" name:"BuildContent"`
}

// CreateImagePipelineImageOptions is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineImageOptions struct {
	ImageName     string                                          `name:"ImageName"`
	ImageFamily   string                                          `name:"ImageFamily"`
	Description   string                                          `name:"Description"`
	ImageFeatures CreateImagePipelineImageOptionsImageFeatures    `name:"ImageFeatures" type:"Struct"`
	ImageTags     *[]CreateImagePipelineImageOptionsImageTagsItem `name:"ImageTags" type:"Repeated"`
}

// CreateImagePipelineTag is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateImagePipelineAdvancedOptions is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineAdvancedOptions struct {
	RetainCloudAssistant string `name:"RetainCloudAssistant"`
	SkipBuildImage       string `name:"SkipBuildImage"`
	SkipCheckImage       string `name:"SkipCheckImage"`
	ImageNameSuffix      string `name:"ImageNameSuffix"`
}

// CreateImagePipelineImportImageOptions is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineImportImageOptions struct {
	Architecture        string                                                         `name:"Architecture"`
	OSType              string                                                         `name:"OSType"`
	Platform            string                                                         `name:"Platform"`
	BootMode            string                                                         `name:"BootMode"`
	LicenseType         string                                                         `name:"LicenseType"`
	DiskDeviceMappings  *[]CreateImagePipelineImportImageOptionsDiskDeviceMappingsItem `name:"DiskDeviceMappings" type:"Repeated"`
	Features            CreateImagePipelineImportImageOptionsFeatures                  `name:"Features" type:"Struct"`
	RetainImportedImage string                                                         `name:"RetainImportedImage"`
}

// CreateImagePipelineImageOptionsImageFeatures is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineImageOptionsImageFeatures struct {
	NvmeSupport string `name:"NvmeSupport"`
}

// CreateImagePipelineImageOptionsImageTagsItem is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineImageOptionsImageTagsItem struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateImagePipelineImportImageOptionsDiskDeviceMappingsItem is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineImportImageOptionsDiskDeviceMappingsItem struct {
	OSSBucket     string `name:"OSSBucket"`
	OSSObject     string `name:"OSSObject"`
	Format        string `name:"Format"`
	DiskImageSize string `name:"DiskImageSize"`
}

// CreateImagePipelineImportImageOptionsFeatures is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineImportImageOptionsFeatures struct {
	NvmeSupport string `name:"NvmeSupport"`
}

// CreateImagePipelineResponse is the response struct for api CreateImagePipeline
type CreateImagePipelineResponse struct {
	*responses.BaseResponse
	ImagePipelineId string `json:"ImagePipelineId" xml:"ImagePipelineId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateImagePipelineRequest creates a request to invoke CreateImagePipeline API
func CreateCreateImagePipelineRequest() (request *CreateImagePipelineRequest) {
	request = &CreateImagePipelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateImagePipeline", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateImagePipelineResponse creates a response to parse from CreateImagePipeline response
func CreateCreateImagePipelineResponse() (response *CreateImagePipelineResponse) {
	response = &CreateImagePipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
