package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateElasticNetworkInterface invokes the eflo.CreateElasticNetworkInterface API synchronously
func (client *Client) CreateElasticNetworkInterface(request *CreateElasticNetworkInterfaceRequest) (response *CreateElasticNetworkInterfaceResponse, err error) {
	response = CreateCreateElasticNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateElasticNetworkInterfaceWithChan invokes the eflo.CreateElasticNetworkInterface API asynchronously
func (client *Client) CreateElasticNetworkInterfaceWithChan(request *CreateElasticNetworkInterfaceRequest) (<-chan *CreateElasticNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *CreateElasticNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateElasticNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateElasticNetworkInterfaceWithCallback invokes the eflo.CreateElasticNetworkInterface API asynchronously
func (client *Client) CreateElasticNetworkInterfaceWithCallback(request *CreateElasticNetworkInterfaceRequest, callback func(response *CreateElasticNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateElasticNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.CreateElasticNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateElasticNetworkInterfaceRequest is the request struct for api CreateElasticNetworkInterface
type CreateElasticNetworkInterfaceRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Body" name:"ClientToken"`
	SecurityGroupId  string           `position:"Body" name:"SecurityGroupId"`
	Description      string           `position:"Body" name:"Description"`
	NodeId           string           `position:"Body" name:"NodeId"`
	EnableJumboFrame requests.Boolean `position:"Body" name:"EnableJumboFrame"`
	VSwitchId        string           `position:"Body" name:"VSwitchId"`
	VpcId            string           `position:"Body" name:"VpcId"`
	ZoneId           string           `position:"Body" name:"ZoneId"`
}

// CreateElasticNetworkInterfaceResponse is the response struct for api CreateElasticNetworkInterface
type CreateElasticNetworkInterfaceResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateCreateElasticNetworkInterfaceRequest creates a request to invoke CreateElasticNetworkInterface API
func CreateCreateElasticNetworkInterfaceRequest() (request *CreateElasticNetworkInterfaceRequest) {
	request = &CreateElasticNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "CreateElasticNetworkInterface", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateElasticNetworkInterfaceResponse creates a response to parse from CreateElasticNetworkInterface response
func CreateCreateElasticNetworkInterfaceResponse() (response *CreateElasticNetworkInterfaceResponse) {
	response = &CreateElasticNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
