package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEr invokes the eflo.GetEr API synchronously
func (client *Client) GetEr(request *GetErRequest) (response *GetErResponse, err error) {
	response = CreateGetErResponse()
	err = client.DoAction(request, response)
	return
}

// GetErWithChan invokes the eflo.GetEr API asynchronously
func (client *Client) GetErWithChan(request *GetErRequest) (<-chan *GetErResponse, <-chan error) {
	responseChan := make(chan *GetErResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetErWithCallback invokes the eflo.GetEr API asynchronously
func (client *Client) GetErWithCallback(request *GetErRequest, callback func(response *GetErResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetErResponse
		var err error
		defer close(result)
		response, err = client.GetEr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetErRequest is the request struct for api GetEr
type GetErRequest struct {
	*requests.RpcRequest
	ErId string `position:"Body" name:"ErId"`
}

// GetErResponse is the response struct for api GetEr
type GetErResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetErRequest creates a request to invoke GetEr API
func CreateGetErRequest() (request *GetErRequest) {
	request = &GetErRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetEr", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetErResponse creates a response to parse from GetEr response
func CreateGetErResponse() (response *GetErResponse) {
	response = &GetErResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
