package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVccs invokes the eflo.ListVccs API synchronously
func (client *Client) ListVccs(request *ListVccsRequest) (response *ListVccsResponse, err error) {
	response = CreateListVccsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVccsWithChan invokes the eflo.ListVccs API asynchronously
func (client *Client) ListVccsWithChan(request *ListVccsRequest) (<-chan *ListVccsResponse, <-chan error) {
	responseChan := make(chan *ListVccsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVccs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVccsWithCallback invokes the eflo.ListVccs API asynchronously
func (client *Client) ListVccsWithCallback(request *ListVccsRequest, callback func(response *ListVccsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVccsResponse
		var err error
		defer close(result)
		response, err = client.ListVccs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVccsRequest is the request struct for api ListVccs
type ListVccsRequest struct {
	*requests.RpcRequest
	CenId           string           `position:"Body" name:"CenId"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	ResourceGroupId string           `position:"Body" name:"ResourceGroupId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	Tag             *[]ListVccsTag   `position:"Body" name:"Tag"  type:"Repeated"`
	VccId           string           `position:"Body" name:"VccId"`
	Bandwidth       requests.Integer `position:"Body" name:"Bandwidth"`
	ExStatus        string           `position:"Body" name:"ExStatus"`
	FilterErId      string           `position:"Body" name:"FilterErId"`
	VpdId           string           `position:"Body" name:"VpdId"`
	VpcId           string           `position:"Body" name:"VpcId"`
	EnablePage      requests.Boolean `position:"Body" name:"EnablePage"`
	Status          string           `position:"Body" name:"Status"`
}

// ListVccsTag is a repeated param struct in ListVccsRequest
type ListVccsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// ListVccsResponse is the response struct for api ListVccs
type ListVccsResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListVccsRequest creates a request to invoke ListVccs API
func CreateListVccsRequest() (request *ListVccsRequest) {
	request = &ListVccsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListVccs", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVccsResponse creates a response to parse from ListVccs response
func CreateListVccsResponse() (response *ListVccsResponse) {
	response = &ListVccsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
