package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpdGrantRules invokes the eflo.ListVpdGrantRules API synchronously
func (client *Client) ListVpdGrantRules(request *ListVpdGrantRulesRequest) (response *ListVpdGrantRulesResponse, err error) {
	response = CreateListVpdGrantRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpdGrantRulesWithChan invokes the eflo.ListVpdGrantRules API asynchronously
func (client *Client) ListVpdGrantRulesWithChan(request *ListVpdGrantRulesRequest) (<-chan *ListVpdGrantRulesResponse, <-chan error) {
	responseChan := make(chan *ListVpdGrantRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpdGrantRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpdGrantRulesWithCallback invokes the eflo.ListVpdGrantRules API asynchronously
func (client *Client) ListVpdGrantRulesWithCallback(request *ListVpdGrantRulesRequest, callback func(response *ListVpdGrantRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpdGrantRulesResponse
		var err error
		defer close(result)
		response, err = client.ListVpdGrantRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpdGrantRulesRequest is the request struct for api ListVpdGrantRules
type ListVpdGrantRulesRequest struct {
	*requests.RpcRequest
	GrantTenantId   string           `position:"Body" name:"GrantTenantId"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	ResourceGroupId string           `position:"Body" name:"ResourceGroupId"`
	GrantRuleId     string           `position:"Body" name:"GrantRuleId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	ErId            string           `position:"Body" name:"ErId"`
	ForSelect       requests.Boolean `position:"Body" name:"ForSelect"`
	InstanceId      string           `position:"Body" name:"InstanceId"`
	InstanceName    string           `position:"Body" name:"InstanceName"`
	EnablePage      requests.Boolean `position:"Body" name:"EnablePage"`
}

// ListVpdGrantRulesResponse is the response struct for api ListVpdGrantRules
type ListVpdGrantRulesResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListVpdGrantRulesRequest creates a request to invoke ListVpdGrantRules API
func CreateListVpdGrantRulesRequest() (request *ListVpdGrantRulesRequest) {
	request = &ListVpdGrantRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListVpdGrantRules", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpdGrantRulesResponse creates a response to parse from ListVpdGrantRules response
func CreateListVpdGrantRulesResponse() (response *ListVpdGrantRulesResponse) {
	response = &ListVpdGrantRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
