package eipanycast

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateAnycastEipAddress invokes the eipanycast.AssociateAnycastEipAddress API synchronously
func (client *Client) AssociateAnycastEipAddress(request *AssociateAnycastEipAddressRequest) (response *AssociateAnycastEipAddressResponse, err error) {
	response = CreateAssociateAnycastEipAddressResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateAnycastEipAddressWithChan invokes the eipanycast.AssociateAnycastEipAddress API asynchronously
func (client *Client) AssociateAnycastEipAddressWithChan(request *AssociateAnycastEipAddressRequest) (<-chan *AssociateAnycastEipAddressResponse, <-chan error) {
	responseChan := make(chan *AssociateAnycastEipAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateAnycastEipAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateAnycastEipAddressWithCallback invokes the eipanycast.AssociateAnycastEipAddress API asynchronously
func (client *Client) AssociateAnycastEipAddressWithCallback(request *AssociateAnycastEipAddressRequest, callback func(response *AssociateAnycastEipAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateAnycastEipAddressResponse
		var err error
		defer close(result)
		response, err = client.AssociateAnycastEipAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateAnycastEipAddressRequest is the request struct for api AssociateAnycastEipAddress
type AssociateAnycastEipAddressRequest struct {
	*requests.RpcRequest
	ClientToken          string                                    `position:"Query" name:"ClientToken"`
	PopLocations         *[]AssociateAnycastEipAddressPopLocations `position:"Query" name:"PopLocations"  type:"Repeated"`
	DryRun               requests.Boolean                          `position:"Query" name:"DryRun"`
	AssociationMode      string                                    `position:"Query" name:"AssociationMode"`
	BindInstanceType     string                                    `position:"Query" name:"BindInstanceType"`
	BindInstanceRegionId string                                    `position:"Query" name:"BindInstanceRegionId"`
	PrivateIpAddress     string                                    `position:"Query" name:"PrivateIpAddress"`
	AnycastId            string                                    `position:"Query" name:"AnycastId"`
	BindInstanceId       string                                    `position:"Query" name:"BindInstanceId"`
}

// AssociateAnycastEipAddressPopLocations is a repeated param struct in AssociateAnycastEipAddressRequest
type AssociateAnycastEipAddressPopLocations struct {
	PopLocation string `name:"PopLocation"`
}

// AssociateAnycastEipAddressResponse is the response struct for api AssociateAnycastEipAddress
type AssociateAnycastEipAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateAnycastEipAddressRequest creates a request to invoke AssociateAnycastEipAddress API
func CreateAssociateAnycastEipAddressRequest() (request *AssociateAnycastEipAddressRequest) {
	request = &AssociateAnycastEipAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eipanycast", "2020-03-09", "AssociateAnycastEipAddress", "eipanycast", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateAnycastEipAddressResponse creates a response to parse from AssociateAnycastEipAddress response
func CreateAssociateAnycastEipAddressResponse() (response *AssociateAnycastEipAddressResponse) {
	response = &AssociateAnycastEipAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
