package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteConnectedCluster invokes the elasticsearch.DeleteConnectedCluster API synchronously
func (client *Client) DeleteConnectedCluster(request *DeleteConnectedClusterRequest) (response *DeleteConnectedClusterResponse, err error) {
	response = CreateDeleteConnectedClusterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteConnectedClusterWithChan invokes the elasticsearch.DeleteConnectedCluster API asynchronously
func (client *Client) DeleteConnectedClusterWithChan(request *DeleteConnectedClusterRequest) (<-chan *DeleteConnectedClusterResponse, <-chan error) {
	responseChan := make(chan *DeleteConnectedClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteConnectedCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteConnectedClusterWithCallback invokes the elasticsearch.DeleteConnectedCluster API asynchronously
func (client *Client) DeleteConnectedClusterWithCallback(request *DeleteConnectedClusterRequest, callback func(response *DeleteConnectedClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteConnectedClusterResponse
		var err error
		defer close(result)
		response, err = client.DeleteConnectedCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteConnectedClusterRequest is the request struct for api DeleteConnectedCluster
type DeleteConnectedClusterRequest struct {
	*requests.RoaRequest
	InstanceId          string `position:"Path" name:"InstanceId"`
	ClientToken         string `position:"Query" name:"clientToken"`
	ConnectedInstanceId string `position:"Query" name:"connectedInstanceId"`
}

// DeleteConnectedClusterResponse is the response struct for api DeleteConnectedCluster
type DeleteConnectedClusterResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteConnectedClusterRequest creates a request to invoke DeleteConnectedCluster API
func CreateDeleteConnectedClusterRequest() (request *DeleteConnectedClusterRequest) {
	request = &DeleteConnectedClusterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DeleteConnectedCluster", "/openapi/instances/[InstanceId]/connected-clusters", "elasticsearch", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteConnectedClusterResponse creates a response to parse from DeleteConnectedCluster response
func CreateDeleteConnectedClusterResponse() (response *DeleteConnectedClusterResponse) {
	response = &DeleteConnectedClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
