package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateILMPolicy invokes the elasticsearch.UpdateILMPolicy API synchronously
func (client *Client) UpdateILMPolicy(request *UpdateILMPolicyRequest) (response *UpdateILMPolicyResponse, err error) {
	response = CreateUpdateILMPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateILMPolicyWithChan invokes the elasticsearch.UpdateILMPolicy API asynchronously
func (client *Client) UpdateILMPolicyWithChan(request *UpdateILMPolicyRequest) (<-chan *UpdateILMPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateILMPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateILMPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateILMPolicyWithCallback invokes the elasticsearch.UpdateILMPolicy API asynchronously
func (client *Client) UpdateILMPolicyWithCallback(request *UpdateILMPolicyRequest, callback func(response *UpdateILMPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateILMPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateILMPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateILMPolicyRequest is the request struct for api UpdateILMPolicy
type UpdateILMPolicyRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	PolicyName  string `position:"Path" name:"PolicyName"`
	Body        string `position:"Body" name:"body"`
}

// UpdateILMPolicyResponse is the response struct for api UpdateILMPolicy
type UpdateILMPolicyResponse struct {
	*responses.BaseResponse
	Result    string `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateILMPolicyRequest creates a request to invoke UpdateILMPolicy API
func CreateUpdateILMPolicyRequest() (request *UpdateILMPolicyRequest) {
	request = &UpdateILMPolicyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateILMPolicy", "/openapi/instances/[InstanceId]/ilm-policies/[PolicyName]", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateILMPolicyResponse creates a response to parse from UpdateILMPolicy response
func CreateUpdateILMPolicyResponse() (response *UpdateILMPolicyResponse) {
	response = &UpdateILMPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
