package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLogstashChargeType invokes the elasticsearch.UpdateLogstashChargeType API synchronously
func (client *Client) UpdateLogstashChargeType(request *UpdateLogstashChargeTypeRequest) (response *UpdateLogstashChargeTypeResponse, err error) {
	response = CreateUpdateLogstashChargeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLogstashChargeTypeWithChan invokes the elasticsearch.UpdateLogstashChargeType API asynchronously
func (client *Client) UpdateLogstashChargeTypeWithChan(request *UpdateLogstashChargeTypeRequest) (<-chan *UpdateLogstashChargeTypeResponse, <-chan error) {
	responseChan := make(chan *UpdateLogstashChargeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLogstashChargeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLogstashChargeTypeWithCallback invokes the elasticsearch.UpdateLogstashChargeType API asynchronously
func (client *Client) UpdateLogstashChargeTypeWithCallback(request *UpdateLogstashChargeTypeRequest, callback func(response *UpdateLogstashChargeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLogstashChargeTypeResponse
		var err error
		defer close(result)
		response, err = client.UpdateLogstashChargeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLogstashChargeTypeRequest is the request struct for api UpdateLogstashChargeType
type UpdateLogstashChargeTypeRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
	Body        string `position:"Body" name:"body"`
}

// UpdateLogstashChargeTypeResponse is the response struct for api UpdateLogstashChargeType
type UpdateLogstashChargeTypeResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLogstashChargeTypeRequest creates a request to invoke UpdateLogstashChargeType API
func CreateUpdateLogstashChargeTypeRequest() (request *UpdateLogstashChargeTypeRequest) {
	request = &UpdateLogstashChargeTypeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateLogstashChargeType", "/openapi/logstashes/[InstanceId]/actions/convert-pay-type", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLogstashChargeTypeResponse creates a response to parse from UpdateLogstashChargeType response
func CreateUpdateLogstashChargeTypeResponse() (response *UpdateLogstashChargeTypeResponse) {
	response = &UpdateLogstashChargeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
