package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEmrAvailableResource invokes the emr.ListEmrAvailableResource API synchronously
func (client *Client) ListEmrAvailableResource(request *ListEmrAvailableResourceRequest) (response *ListEmrAvailableResourceResponse, err error) {
	response = CreateListEmrAvailableResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListEmrAvailableResourceWithChan invokes the emr.ListEmrAvailableResource API asynchronously
func (client *Client) ListEmrAvailableResourceWithChan(request *ListEmrAvailableResourceRequest) (<-chan *ListEmrAvailableResourceResponse, <-chan error) {
	responseChan := make(chan *ListEmrAvailableResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEmrAvailableResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEmrAvailableResourceWithCallback invokes the emr.ListEmrAvailableResource API asynchronously
func (client *Client) ListEmrAvailableResourceWithCallback(request *ListEmrAvailableResourceRequest, callback func(response *ListEmrAvailableResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEmrAvailableResourceResponse
		var err error
		defer close(result)
		response, err = client.ListEmrAvailableResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEmrAvailableResourceRequest is the request struct for api ListEmrAvailableResource
type ListEmrAvailableResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId     requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DepositType         string           `position:"Query" name:"DepositType"`
	SystemDiskType      string           `position:"Query" name:"SystemDiskType"`
	ResourceGroupId     string           `position:"Query" name:"ResourceGroupId"`
	InstanceType        string           `position:"Query" name:"InstanceType"`
	EmrVersion          string           `position:"Query" name:"EmrVersion"`
	InstanceChargeType  string           `position:"Query" name:"InstanceChargeType"`
	ClusterId           string           `position:"Query" name:"ClusterId"`
	DestinationResource string           `position:"Query" name:"DestinationResource"`
	ClusterType         string           `position:"Query" name:"ClusterType"`
	SpotStrategy        string           `position:"Query" name:"SpotStrategy"`
	NetType             string           `position:"Query" name:"NetType"`
	ZoneId              string           `position:"Query" name:"ZoneId"`
	DataDiskType        string           `position:"Query" name:"DataDiskType"`
}

// ListEmrAvailableResourceResponse is the response struct for api ListEmrAvailableResource
type ListEmrAvailableResourceResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	RegionId        string          `json:"RegionId" xml:"RegionId"`
	EmrZoneInfoList EmrZoneInfoList `json:"EmrZoneInfoList" xml:"EmrZoneInfoList"`
}

// CreateListEmrAvailableResourceRequest creates a request to invoke ListEmrAvailableResource API
func CreateListEmrAvailableResourceRequest() (request *ListEmrAvailableResourceRequest) {
	request = &ListEmrAvailableResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListEmrAvailableResource", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEmrAvailableResourceResponse creates a response to parse from ListEmrAvailableResource response
func CreateListEmrAvailableResourceResponse() (response *ListEmrAvailableResourceResponse) {
	response = &ListEmrAvailableResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
