package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CopySDG invokes the ens.CopySDG API synchronously
func (client *Client) CopySDG(request *CopySDGRequest) (response *CopySDGResponse, err error) {
	response = CreateCopySDGResponse()
	err = client.DoAction(request, response)
	return
}

// CopySDGWithChan invokes the ens.CopySDG API asynchronously
func (client *Client) CopySDGWithChan(request *CopySDGRequest) (<-chan *CopySDGResponse, <-chan error) {
	responseChan := make(chan *CopySDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CopySDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CopySDGWithCallback invokes the ens.CopySDG API asynchronously
func (client *Client) CopySDGWithCallback(request *CopySDGRequest, callback func(response *CopySDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CopySDGResponse
		var err error
		defer close(result)
		response, err = client.CopySDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CopySDGRequest is the request struct for api CopySDG
type CopySDGRequest struct {
	*requests.RpcRequest
	DestinationRegionIds *[]string `position:"Query" name:"DestinationRegionIds"  type:"Json"`
	SDGId                string    `position:"Query" name:"SDGId"`
}

// CopySDGResponse is the response struct for api CopySDG
type CopySDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCopySDGRequest creates a request to invoke CopySDG API
func CreateCopySDGRequest() (request *CopySDGRequest) {
	request = &CopySDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CopySDG", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCopySDGResponse creates a response to parse from CopySDG response
func CreateCopySDGResponse() (response *CopySDGResponse) {
	response = &CopySDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
