package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBucketLifecycle invokes the ens.DeleteBucketLifecycle API synchronously
func (client *Client) DeleteBucketLifecycle(request *DeleteBucketLifecycleRequest) (response *DeleteBucketLifecycleResponse, err error) {
	response = CreateDeleteBucketLifecycleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBucketLifecycleWithChan invokes the ens.DeleteBucketLifecycle API asynchronously
func (client *Client) DeleteBucketLifecycleWithChan(request *DeleteBucketLifecycleRequest) (<-chan *DeleteBucketLifecycleResponse, <-chan error) {
	responseChan := make(chan *DeleteBucketLifecycleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBucketLifecycle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBucketLifecycleWithCallback invokes the ens.DeleteBucketLifecycle API asynchronously
func (client *Client) DeleteBucketLifecycleWithCallback(request *DeleteBucketLifecycleRequest, callback func(response *DeleteBucketLifecycleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBucketLifecycleResponse
		var err error
		defer close(result)
		response, err = client.DeleteBucketLifecycle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBucketLifecycleRequest is the request struct for api DeleteBucketLifecycle
type DeleteBucketLifecycleRequest struct {
	*requests.RpcRequest
	BucketName string `position:"Query" name:"BucketName"`
	RuleId     string `position:"Query" name:"RuleId"`
}

// DeleteBucketLifecycleResponse is the response struct for api DeleteBucketLifecycle
type DeleteBucketLifecycleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteBucketLifecycleRequest creates a request to invoke DeleteBucketLifecycle API
func CreateDeleteBucketLifecycleRequest() (request *DeleteBucketLifecycleRequest) {
	request = &DeleteBucketLifecycleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteBucketLifecycle", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteBucketLifecycleResponse creates a response to parse from DeleteBucketLifecycle response
func CreateDeleteBucketLifecycleResponse() (response *DeleteBucketLifecycleResponse) {
	response = &DeleteBucketLifecycleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
