package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskIopsList invokes the ens.DescribeDiskIopsList API synchronously
func (client *Client) DescribeDiskIopsList(request *DescribeDiskIopsListRequest) (response *DescribeDiskIopsListResponse, err error) {
	response = CreateDescribeDiskIopsListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskIopsListWithChan invokes the ens.DescribeDiskIopsList API asynchronously
func (client *Client) DescribeDiskIopsListWithChan(request *DescribeDiskIopsListRequest) (<-chan *DescribeDiskIopsListResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskIopsListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskIopsList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskIopsListWithCallback invokes the ens.DescribeDiskIopsList API asynchronously
func (client *Client) DescribeDiskIopsListWithCallback(request *DescribeDiskIopsListRequest, callback func(response *DescribeDiskIopsListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskIopsListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskIopsList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskIopsListRequest is the request struct for api DescribeDiskIopsList
type DescribeDiskIopsListRequest struct {
	*requests.RpcRequest
	StartTime string `position:"Query" name:"StartTime"`
	DiskId    string `position:"Query" name:"DiskId"`
	EndTime   string `position:"Query" name:"EndTime"`
}

// DescribeDiskIopsListResponse is the response struct for api DescribeDiskIopsList
type DescribeDiskIopsListResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	DiskIopsList []DiskIops `json:"DiskIopsList" xml:"DiskIopsList"`
}

// CreateDescribeDiskIopsListRequest creates a request to invoke DescribeDiskIopsList API
func CreateDescribeDiskIopsListRequest() (request *DescribeDiskIopsListRequest) {
	request = &DescribeDiskIopsListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeDiskIopsList", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDiskIopsListResponse creates a response to parse from DescribeDiskIopsList response
func CreateDescribeDiskIopsListResponse() (response *DescribeDiskIopsListResponse) {
	response = &DescribeDiskIopsListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
