package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsSaleControl invokes the ens.DescribeEnsSaleControl API synchronously
func (client *Client) DescribeEnsSaleControl(request *DescribeEnsSaleControlRequest) (response *DescribeEnsSaleControlResponse, err error) {
	response = CreateDescribeEnsSaleControlResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsSaleControlWithChan invokes the ens.DescribeEnsSaleControl API asynchronously
func (client *Client) DescribeEnsSaleControlWithChan(request *DescribeEnsSaleControlRequest) (<-chan *DescribeEnsSaleControlResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsSaleControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsSaleControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsSaleControlWithCallback invokes the ens.DescribeEnsSaleControl API asynchronously
func (client *Client) DescribeEnsSaleControlWithCallback(request *DescribeEnsSaleControlRequest, callback func(response *DescribeEnsSaleControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsSaleControlResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsSaleControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsSaleControlRequest is the request struct for api DescribeEnsSaleControl
type DescribeEnsSaleControlRequest struct {
	*requests.RpcRequest
	CustomAccount string `position:"Query" name:"CustomAccount"`
	CommodityCode string `position:"Query" name:"CommodityCode"`
	ModuleCode    string `position:"Query" name:"ModuleCode"`
	AliUidAccount string `position:"Query" name:"AliUidAccount"`
	OrderType     string `position:"Query" name:"OrderType"`
}

// DescribeEnsSaleControlResponse is the response struct for api DescribeEnsSaleControl
type DescribeEnsSaleControlResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	SaleControl []SaleControlItem `json:"SaleControl" xml:"SaleControl"`
}

// CreateDescribeEnsSaleControlRequest creates a request to invoke DescribeEnsSaleControl API
func CreateDescribeEnsSaleControlRequest() (request *DescribeEnsSaleControlRequest) {
	request = &DescribeEnsSaleControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsSaleControl", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsSaleControlResponse creates a response to parse from DescribeEnsSaleControl response
func CreateDescribeEnsSaleControlResponse() (response *DescribeEnsSaleControlResponse) {
	response = &DescribeEnsSaleControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
