package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceBandwidthDetail invokes the ens.DescribeInstanceBandwidthDetail API synchronously
func (client *Client) DescribeInstanceBandwidthDetail(request *DescribeInstanceBandwidthDetailRequest) (response *DescribeInstanceBandwidthDetailResponse, err error) {
	response = CreateDescribeInstanceBandwidthDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceBandwidthDetailWithChan invokes the ens.DescribeInstanceBandwidthDetail API asynchronously
func (client *Client) DescribeInstanceBandwidthDetailWithChan(request *DescribeInstanceBandwidthDetailRequest) (<-chan *DescribeInstanceBandwidthDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceBandwidthDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceBandwidthDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceBandwidthDetailWithCallback invokes the ens.DescribeInstanceBandwidthDetail API asynchronously
func (client *Client) DescribeInstanceBandwidthDetailWithCallback(request *DescribeInstanceBandwidthDetailRequest, callback func(response *DescribeInstanceBandwidthDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceBandwidthDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceBandwidthDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceBandwidthDetailRequest is the request struct for api DescribeInstanceBandwidthDetail
type DescribeInstanceBandwidthDetailRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	EnsRegionId  string           `position:"Query" name:"EnsRegionId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	InstanceType string           `position:"Query" name:"InstanceType"`
	EndTime      string           `position:"Query" name:"EndTime"`
	ServiceType  string           `position:"Query" name:"ServiceType"`
}

// DescribeInstanceBandwidthDetailResponse is the response struct for api DescribeInstanceBandwidthDetail
type DescribeInstanceBandwidthDetailResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	PageNumber int         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int         `json:"PageSize" xml:"PageSize"`
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	Bandwidths []Bandwidth `json:"Bandwidths" xml:"Bandwidths"`
}

// CreateDescribeInstanceBandwidthDetailRequest creates a request to invoke DescribeInstanceBandwidthDetail API
func CreateDescribeInstanceBandwidthDetailRequest() (request *DescribeInstanceBandwidthDetailRequest) {
	request = &DescribeInstanceBandwidthDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeInstanceBandwidthDetail", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeInstanceBandwidthDetailResponse creates a response to parse from DescribeInstanceBandwidthDetail response
func CreateDescribeInstanceBandwidthDetailResponse() (response *DescribeInstanceBandwidthDetailResponse) {
	response = &DescribeInstanceBandwidthDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
