package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebootARMServerInstance invokes the ens.RebootARMServerInstance API synchronously
func (client *Client) RebootARMServerInstance(request *RebootARMServerInstanceRequest) (response *RebootARMServerInstanceResponse, err error) {
	response = CreateRebootARMServerInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RebootARMServerInstanceWithChan invokes the ens.RebootARMServerInstance API asynchronously
func (client *Client) RebootARMServerInstanceWithChan(request *RebootARMServerInstanceRequest) (<-chan *RebootARMServerInstanceResponse, <-chan error) {
	responseChan := make(chan *RebootARMServerInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebootARMServerInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebootARMServerInstanceWithCallback invokes the ens.RebootARMServerInstance API asynchronously
func (client *Client) RebootARMServerInstanceWithCallback(request *RebootARMServerInstanceRequest, callback func(response *RebootARMServerInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebootARMServerInstanceResponse
		var err error
		defer close(result)
		response, err = client.RebootARMServerInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebootARMServerInstanceRequest is the request struct for api RebootARMServerInstance
type RebootARMServerInstanceRequest struct {
	*requests.RpcRequest
	ServerId string `position:"Query" name:"ServerId"`
}

// RebootARMServerInstanceResponse is the response struct for api RebootARMServerInstance
type RebootARMServerInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRebootARMServerInstanceRequest creates a request to invoke RebootARMServerInstance API
func CreateRebootARMServerInstanceRequest() (request *RebootARMServerInstanceRequest) {
	request = &RebootARMServerInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RebootARMServerInstance", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateRebootARMServerInstanceResponse creates a response to parse from RebootARMServerInstance response
func CreateRebootARMServerInstanceResponse() (response *RebootARMServerInstanceResponse) {
	response = &RebootARMServerInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
