package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScalingInstances invokes the ess.DescribeScalingInstances API synchronously
func (client *Client) DescribeScalingInstances(request *DescribeScalingInstancesRequest) (response *DescribeScalingInstancesResponse, err error) {
	response = CreateDescribeScalingInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScalingInstancesWithChan invokes the ess.DescribeScalingInstances API asynchronously
func (client *Client) DescribeScalingInstancesWithChan(request *DescribeScalingInstancesRequest) (<-chan *DescribeScalingInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeScalingInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScalingInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScalingInstancesWithCallback invokes the ess.DescribeScalingInstances API asynchronously
func (client *Client) DescribeScalingInstancesWithCallback(request *DescribeScalingInstancesRequest, callback func(response *DescribeScalingInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScalingInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeScalingInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScalingInstancesRequest is the request struct for api DescribeScalingInstances
type DescribeScalingInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ScalingGroupId         string           `position:"Query" name:"ScalingGroupId"`
	LifecycleState         string           `position:"Query" name:"LifecycleState"`
	CreationType           string           `position:"Query" name:"CreationType"`
	PageNumber             requests.Integer `position:"Query" name:"PageNumber"`
	PageSize               requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	ScalingActivityId      string           `position:"Query" name:"ScalingActivityId"`
	CreationTypes          *[]string        `position:"Query" name:"CreationTypes"  type:"Repeated"`
	ScalingConfigurationId string           `position:"Query" name:"ScalingConfigurationId"`
	InstanceId             *[]string        `position:"Query" name:"InstanceId"  type:"Repeated"`
	HealthStatus           string           `position:"Query" name:"HealthStatus"`
	LifecycleStates        *[]string        `position:"Query" name:"LifecycleStates"  type:"Repeated"`
}

// DescribeScalingInstancesResponse is the response struct for api DescribeScalingInstances
type DescribeScalingInstancesResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	PageSize         int              `json:"PageSize" xml:"PageSize"`
	PageNumber       int              `json:"PageNumber" xml:"PageNumber"`
	TotalSpotCount   int              `json:"TotalSpotCount" xml:"TotalSpotCount"`
	TotalCount       int              `json:"TotalCount" xml:"TotalCount"`
	ScalingInstances ScalingInstances `json:"ScalingInstances" xml:"ScalingInstances"`
}

// CreateDescribeScalingInstancesRequest creates a request to invoke DescribeScalingInstances API
func CreateDescribeScalingInstancesRequest() (request *DescribeScalingInstancesRequest) {
	request = &DescribeScalingInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DescribeScalingInstances", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeScalingInstancesResponse creates a response to parse from DescribeScalingInstances response
func CreateDescribeScalingInstancesResponse() (response *DescribeScalingInstancesResponse) {
	response = &DescribeScalingInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
