package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApiDestinations invokes the eventbridge.ListApiDestinations API synchronously
func (client *Client) ListApiDestinations(request *ListApiDestinationsRequest) (response *ListApiDestinationsResponse, err error) {
	response = CreateListApiDestinationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListApiDestinationsWithChan invokes the eventbridge.ListApiDestinations API asynchronously
func (client *Client) ListApiDestinationsWithChan(request *ListApiDestinationsRequest) (<-chan *ListApiDestinationsResponse, <-chan error) {
	responseChan := make(chan *ListApiDestinationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApiDestinations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApiDestinationsWithCallback invokes the eventbridge.ListApiDestinations API asynchronously
func (client *Client) ListApiDestinationsWithCallback(request *ListApiDestinationsRequest, callback func(response *ListApiDestinationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApiDestinationsResponse
		var err error
		defer close(result)
		response, err = client.ListApiDestinations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApiDestinationsRequest is the request struct for api ListApiDestinations
type ListApiDestinationsRequest struct {
	*requests.RpcRequest
	ClientToken              string           `position:"Query" name:"ClientToken"`
	Description              string           `position:"Query" name:"Description"`
	NextToken                string           `position:"Query" name:"NextToken"`
	ConnectionName           string           `position:"Query" name:"ConnectionName"`
	MaxResults               requests.Integer `position:"Query" name:"MaxResults"`
	ApiDestinationNamePrefix string           `position:"Query" name:"ApiDestinationNamePrefix"`
}

// ListApiDestinationsResponse is the response struct for api ListApiDestinations
type ListApiDestinationsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListApiDestinationsRequest creates a request to invoke ListApiDestinations API
func CreateListApiDestinationsRequest() (request *ListApiDestinationsRequest) {
	request = &ListApiDestinationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "ListApiDestinations", "", "")
	request.Method = requests.POST
	return
}

// CreateListApiDestinationsResponse creates a response to parse from ListApiDestinations response
func CreateListApiDestinationsResponse() (response *ListApiDestinationsResponse) {
	response = &ListApiDestinationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
