package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BodyPosture invokes the facebody.BodyPosture API synchronously
func (client *Client) BodyPosture(request *BodyPostureRequest) (response *BodyPostureResponse, err error) {
	response = CreateBodyPostureResponse()
	err = client.DoAction(request, response)
	return
}

// BodyPostureWithChan invokes the facebody.BodyPosture API asynchronously
func (client *Client) BodyPostureWithChan(request *BodyPostureRequest) (<-chan *BodyPostureResponse, <-chan error) {
	responseChan := make(chan *BodyPostureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BodyPosture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BodyPostureWithCallback invokes the facebody.BodyPosture API asynchronously
func (client *Client) BodyPostureWithCallback(request *BodyPostureRequest, callback func(response *BodyPostureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BodyPostureResponse
		var err error
		defer close(result)
		response, err = client.BodyPosture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BodyPostureRequest is the request struct for api BodyPosture
type BodyPostureRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// BodyPostureResponse is the response struct for api BodyPosture
type BodyPostureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBodyPostureRequest creates a request to invoke BodyPosture API
func CreateBodyPostureRequest() (request *BodyPostureRequest) {
	request = &BodyPostureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "BodyPosture", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBodyPostureResponse creates a response to parse from BodyPosture response
func CreateBodyPostureResponse() (response *BodyPostureResponse) {
	response = &BodyPostureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
