package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEnrolledAccount invokes the governance.GetEnrolledAccount API synchronously
func (client *Client) GetEnrolledAccount(request *GetEnrolledAccountRequest) (response *GetEnrolledAccountResponse, err error) {
	response = CreateGetEnrolledAccountResponse()
	err = client.DoAction(request, response)
	return
}

// GetEnrolledAccountWithChan invokes the governance.GetEnrolledAccount API asynchronously
func (client *Client) GetEnrolledAccountWithChan(request *GetEnrolledAccountRequest) (<-chan *GetEnrolledAccountResponse, <-chan error) {
	responseChan := make(chan *GetEnrolledAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEnrolledAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEnrolledAccountWithCallback invokes the governance.GetEnrolledAccount API asynchronously
func (client *Client) GetEnrolledAccountWithCallback(request *GetEnrolledAccountRequest, callback func(response *GetEnrolledAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEnrolledAccountResponse
		var err error
		defer close(result)
		response, err = client.GetEnrolledAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEnrolledAccountRequest is the request struct for api GetEnrolledAccount
type GetEnrolledAccountRequest struct {
	*requests.RpcRequest
	AccountUid requests.Integer `position:"Query" name:"AccountUid"`
}

// GetEnrolledAccountResponse is the response struct for api GetEnrolledAccount
type GetEnrolledAccountResponse struct {
	*responses.BaseResponse
	AccountUid       int64          `json:"AccountUid" xml:"AccountUid"`
	BaselineId       string         `json:"BaselineId" xml:"BaselineId"`
	CreateTime       string         `json:"CreateTime" xml:"CreateTime"`
	DisplayName      string         `json:"DisplayName" xml:"DisplayName"`
	FolderId         string         `json:"FolderId" xml:"FolderId"`
	Initialized      bool           `json:"Initialized" xml:"Initialized"`
	MasterAccountUid int64          `json:"MasterAccountUid" xml:"MasterAccountUid"`
	PayerAccountUid  int64          `json:"PayerAccountUid" xml:"PayerAccountUid"`
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	Status           string         `json:"Status" xml:"Status"`
	UpdateTime       string         `json:"UpdateTime" xml:"UpdateTime"`
	ErrorInfo        ErrorInfo      `json:"ErrorInfo" xml:"ErrorInfo"`
	Inputs           Inputs         `json:"Inputs" xml:"Inputs"`
	BaselineItems    []BaselineItem `json:"BaselineItems" xml:"BaselineItems"`
	Progress         []Progres      `json:"Progress" xml:"Progress"`
}

// CreateGetEnrolledAccountRequest creates a request to invoke GetEnrolledAccount API
func CreateGetEnrolledAccountRequest() (request *GetEnrolledAccountRequest) {
	request = &GetEnrolledAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "GetEnrolledAccount", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEnrolledAccountResponse creates a response to parse from GetEnrolledAccount response
func CreateGetEnrolledAccountResponse() (response *GetEnrolledAccountResponse) {
	response = &GetEnrolledAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
