package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEvaluationMetricDetails invokes the governance.ListEvaluationMetricDetails API synchronously
func (client *Client) ListEvaluationMetricDetails(request *ListEvaluationMetricDetailsRequest) (response *ListEvaluationMetricDetailsResponse, err error) {
	response = CreateListEvaluationMetricDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// ListEvaluationMetricDetailsWithChan invokes the governance.ListEvaluationMetricDetails API asynchronously
func (client *Client) ListEvaluationMetricDetailsWithChan(request *ListEvaluationMetricDetailsRequest) (<-chan *ListEvaluationMetricDetailsResponse, <-chan error) {
	responseChan := make(chan *ListEvaluationMetricDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEvaluationMetricDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEvaluationMetricDetailsWithCallback invokes the governance.ListEvaluationMetricDetails API asynchronously
func (client *Client) ListEvaluationMetricDetailsWithCallback(request *ListEvaluationMetricDetailsRequest, callback func(response *ListEvaluationMetricDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEvaluationMetricDetailsResponse
		var err error
		defer close(result)
		response, err = client.ListEvaluationMetricDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEvaluationMetricDetailsRequest is the request struct for api ListEvaluationMetricDetails
type ListEvaluationMetricDetailsRequest struct {
	*requests.RpcRequest
	AccountId   requests.Integer `position:"Query" name:"AccountId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	Id          string           `position:"Query" name:"Id"`
	PartnerCode string           `position:"Query" name:"PartnerCode"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// ListEvaluationMetricDetailsResponse is the response struct for api ListEvaluationMetricDetails
type ListEvaluationMetricDetailsResponse struct {
	*responses.BaseResponse
	NextToken string     `json:"NextToken" xml:"NextToken"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Resources []Resource `json:"Resources" xml:"Resources"`
}

// CreateListEvaluationMetricDetailsRequest creates a request to invoke ListEvaluationMetricDetails API
func CreateListEvaluationMetricDetailsRequest() (request *ListEvaluationMetricDetailsRequest) {
	request = &ListEvaluationMetricDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "ListEvaluationMetricDetails", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEvaluationMetricDetailsResponse creates a response to parse from ListEvaluationMetricDetails response
func CreateListEvaluationMetricDetailsResponse() (response *ListEvaluationMetricDetailsResponse) {
	response = &ListEvaluationMetricDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
