package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnloadSampleData invokes the gpdb.UnloadSampleData API synchronously
func (client *Client) UnloadSampleData(request *UnloadSampleDataRequest) (response *UnloadSampleDataResponse, err error) {
	response = CreateUnloadSampleDataResponse()
	err = client.DoAction(request, response)
	return
}

// UnloadSampleDataWithChan invokes the gpdb.UnloadSampleData API asynchronously
func (client *Client) UnloadSampleDataWithChan(request *UnloadSampleDataRequest) (<-chan *UnloadSampleDataResponse, <-chan error) {
	responseChan := make(chan *UnloadSampleDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnloadSampleData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnloadSampleDataWithCallback invokes the gpdb.UnloadSampleData API asynchronously
func (client *Client) UnloadSampleDataWithCallback(request *UnloadSampleDataRequest, callback func(response *UnloadSampleDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnloadSampleDataResponse
		var err error
		defer close(result)
		response, err = client.UnloadSampleData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnloadSampleDataRequest is the request struct for api UnloadSampleData
type UnloadSampleDataRequest struct {
	*requests.RpcRequest
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// UnloadSampleDataResponse is the response struct for api UnloadSampleData
type UnloadSampleDataResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Status       bool   `json:"Status" xml:"Status"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
}

// CreateUnloadSampleDataRequest creates a request to invoke UnloadSampleData API
func CreateUnloadSampleDataRequest() (request *UnloadSampleDataRequest) {
	request = &UnloadSampleDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "UnloadSampleData", "", "")
	request.Method = requests.POST
	return
}

// CreateUnloadSampleDataResponse creates a response to parse from UnloadSampleData response
func CreateUnloadSampleDataResponse() (response *UnloadSampleDataResponse) {
	response = &UnloadSampleDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
