package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ServiceInvoke invokes the idaas_doraemon.ServiceInvoke API synchronously
func (client *Client) ServiceInvoke(request *ServiceInvokeRequest) (response *ServiceInvokeResponse, err error) {
	response = CreateServiceInvokeResponse()
	err = client.DoAction(request, response)
	return
}

// ServiceInvokeWithChan invokes the idaas_doraemon.ServiceInvoke API asynchronously
func (client *Client) ServiceInvokeWithChan(request *ServiceInvokeRequest) (<-chan *ServiceInvokeResponse, <-chan error) {
	responseChan := make(chan *ServiceInvokeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ServiceInvoke(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ServiceInvokeWithCallback invokes the idaas_doraemon.ServiceInvoke API asynchronously
func (client *Client) ServiceInvokeWithCallback(request *ServiceInvokeRequest, callback func(response *ServiceInvokeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ServiceInvokeResponse
		var err error
		defer close(result)
		response, err = client.ServiceInvoke(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ServiceInvokeRequest is the request struct for api ServiceInvoke
type ServiceInvokeRequest struct {
	*requests.RpcRequest
	XClientIp                  string           `position:"Query" name:"XClientIp"`
	MobileExtendParamsJsonSign string           `position:"Query" name:"MobileExtendParamsJsonSign"`
	ServerExtendParamsJson     string           `position:"Query" name:"ServerExtendParamsJson"`
	DoraemonAction             string           `position:"Query" name:"DoraemonAction"`
	MobileExtendParamsJson     string           `position:"Query" name:"MobileExtendParamsJson"`
	ServiceCode                string           `position:"Query" name:"ServiceCode"`
	TestModel                  requests.Boolean `position:"Query" name:"TestModel"`
	ApplicationExternalId      string           `position:"Query" name:"ApplicationExternalId"`
}

// ServiceInvokeResponse is the response struct for api ServiceInvoke
type ServiceInvokeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	IdToken   string `json:"IdToken" xml:"IdToken"`
	EventId   string `json:"EventId" xml:"EventId"`
}

// CreateServiceInvokeRequest creates a request to invoke ServiceInvoke API
func CreateServiceInvokeRequest() (request *ServiceInvokeRequest) {
	request = &ServiceInvokeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "ServiceInvoke", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateServiceInvokeResponse creates a response to parse from ServiceInvoke response
func CreateServiceInvokeResponse() (response *ServiceInvokeResponse) {
	response = &ServiceInvokeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
