package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScreenGC invokes the imageprocess.ScreenGC API synchronously
func (client *Client) ScreenGC(request *ScreenGCRequest) (response *ScreenGCResponse, err error) {
	response = CreateScreenGCResponse()
	err = client.DoAction(request, response)
	return
}

// ScreenGCWithChan invokes the imageprocess.ScreenGC API asynchronously
func (client *Client) ScreenGCWithChan(request *ScreenGCRequest) (<-chan *ScreenGCResponse, <-chan error) {
	responseChan := make(chan *ScreenGCResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScreenGC(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScreenGCWithCallback invokes the imageprocess.ScreenGC API asynchronously
func (client *Client) ScreenGCWithCallback(request *ScreenGCRequest, callback func(response *ScreenGCResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScreenGCResponse
		var err error
		defer close(result)
		response, err = client.ScreenGC(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScreenGCRequest is the request struct for api ScreenGC
type ScreenGCRequest struct {
	*requests.RpcRequest
	DataSourceType string             `position:"Body" name:"DataSourceType"`
	OrgName        string             `position:"Body" name:"OrgName"`
	DataFormat     string             `position:"Body" name:"DataFormat"`
	URLList        *[]ScreenGCURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId          string             `position:"Body" name:"OrgId"`
	Async          requests.Boolean   `position:"Body" name:"Async"`
}

// ScreenGCURLList is a repeated param struct in ScreenGCRequest
type ScreenGCURLList struct {
	URL string `name:"URL"`
}

// ScreenGCResponse is the response struct for api ScreenGC
type ScreenGCResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateScreenGCRequest creates a request to invoke ScreenGC API
func CreateScreenGCRequest() (request *ScreenGCRequest) {
	request = &ScreenGCRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "ScreenGC", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScreenGCResponse creates a response to parse from ScreenGC response
func CreateScreenGCResponse() (response *ScreenGCResponse) {
	response = &ScreenGCResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
