package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDeviceToSharePromotion invokes the iot.AddDeviceToSharePromotion API synchronously
func (client *Client) AddDeviceToSharePromotion(request *AddDeviceToSharePromotionRequest) (response *AddDeviceToSharePromotionResponse, err error) {
	response = CreateAddDeviceToSharePromotionResponse()
	err = client.DoAction(request, response)
	return
}

// AddDeviceToSharePromotionWithChan invokes the iot.AddDeviceToSharePromotion API asynchronously
func (client *Client) AddDeviceToSharePromotionWithChan(request *AddDeviceToSharePromotionRequest) (<-chan *AddDeviceToSharePromotionResponse, <-chan error) {
	responseChan := make(chan *AddDeviceToSharePromotionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDeviceToSharePromotion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDeviceToSharePromotionWithCallback invokes the iot.AddDeviceToSharePromotion API asynchronously
func (client *Client) AddDeviceToSharePromotionWithCallback(request *AddDeviceToSharePromotionRequest, callback func(response *AddDeviceToSharePromotionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDeviceToSharePromotionResponse
		var err error
		defer close(result)
		response, err = client.AddDeviceToSharePromotion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDeviceToSharePromotionRequest is the request struct for api AddDeviceToSharePromotion
type AddDeviceToSharePromotionRequest struct {
	*requests.RpcRequest
	SharePromotionActivityId string                                           `position:"Body" name:"SharePromotionActivityId"`
	DeviceSimpleInfoList     *[]AddDeviceToSharePromotionDeviceSimpleInfoList `position:"Body" name:"DeviceSimpleInfoList"  type:"Repeated"`
	IotInstanceId            string                                           `position:"Body" name:"IotInstanceId"`
	ShareTaskCode            string                                           `position:"Body" name:"ShareTaskCode"`
	ApiProduct               string                                           `position:"Body" name:"ApiProduct"`
	ApiRevision              string                                           `position:"Body" name:"ApiRevision"`
}

// AddDeviceToSharePromotionDeviceSimpleInfoList is a repeated param struct in AddDeviceToSharePromotionRequest
type AddDeviceToSharePromotionDeviceSimpleInfoList struct {
	DeviceName string `name:"DeviceName"`
	ProductKey string `name:"ProductKey"`
}

// AddDeviceToSharePromotionResponse is the response struct for api AddDeviceToSharePromotion
type AddDeviceToSharePromotionResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateAddDeviceToSharePromotionRequest creates a request to invoke AddDeviceToSharePromotion API
func CreateAddDeviceToSharePromotionRequest() (request *AddDeviceToSharePromotionRequest) {
	request = &AddDeviceToSharePromotionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "AddDeviceToSharePromotion", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDeviceToSharePromotionResponse creates a response to parse from AddDeviceToSharePromotion response
func CreateAddDeviceToSharePromotionResponse() (response *AddDeviceToSharePromotionResponse) {
	response = &AddDeviceToSharePromotionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
