package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchCreateSoundCodeLabelWithLabels invokes the iot.BatchCreateSoundCodeLabelWithLabels API synchronously
func (client *Client) BatchCreateSoundCodeLabelWithLabels(request *BatchCreateSoundCodeLabelWithLabelsRequest) (response *BatchCreateSoundCodeLabelWithLabelsResponse, err error) {
	response = CreateBatchCreateSoundCodeLabelWithLabelsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchCreateSoundCodeLabelWithLabelsWithChan invokes the iot.BatchCreateSoundCodeLabelWithLabels API asynchronously
func (client *Client) BatchCreateSoundCodeLabelWithLabelsWithChan(request *BatchCreateSoundCodeLabelWithLabelsRequest) (<-chan *BatchCreateSoundCodeLabelWithLabelsResponse, <-chan error) {
	responseChan := make(chan *BatchCreateSoundCodeLabelWithLabelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchCreateSoundCodeLabelWithLabels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchCreateSoundCodeLabelWithLabelsWithCallback invokes the iot.BatchCreateSoundCodeLabelWithLabels API asynchronously
func (client *Client) BatchCreateSoundCodeLabelWithLabelsWithCallback(request *BatchCreateSoundCodeLabelWithLabelsRequest, callback func(response *BatchCreateSoundCodeLabelWithLabelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchCreateSoundCodeLabelWithLabelsResponse
		var err error
		defer close(result)
		response, err = client.BatchCreateSoundCodeLabelWithLabels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchCreateSoundCodeLabelWithLabelsRequest is the request struct for api BatchCreateSoundCodeLabelWithLabels
type BatchCreateSoundCodeLabelWithLabelsRequest struct {
	*requests.RpcRequest
	ScheduleCode  string    `position:"Body" name:"ScheduleCode"`
	Description   string    `position:"Body" name:"Description"`
	IotInstanceId string    `position:"Body" name:"IotInstanceId"`
	Labels        *[]string `position:"Body" name:"Labels"  type:"Repeated"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// BatchCreateSoundCodeLabelWithLabelsResponse is the response struct for api BatchCreateSoundCodeLabelWithLabels
type BatchCreateSoundCodeLabelWithLabelsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateBatchCreateSoundCodeLabelWithLabelsRequest creates a request to invoke BatchCreateSoundCodeLabelWithLabels API
func CreateBatchCreateSoundCodeLabelWithLabelsRequest() (request *BatchCreateSoundCodeLabelWithLabelsRequest) {
	request = &BatchCreateSoundCodeLabelWithLabelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchCreateSoundCodeLabelWithLabels", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchCreateSoundCodeLabelWithLabelsResponse creates a response to parse from BatchCreateSoundCodeLabelWithLabels response
func CreateBatchCreateSoundCodeLabelWithLabelsResponse() (response *BatchCreateSoundCodeLabelWithLabelsResponse) {
	response = &BatchCreateSoundCodeLabelWithLabelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
