package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTopicRouteTable invokes the iot.DeleteTopicRouteTable API synchronously
func (client *Client) DeleteTopicRouteTable(request *DeleteTopicRouteTableRequest) (response *DeleteTopicRouteTableResponse, err error) {
	response = CreateDeleteTopicRouteTableResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTopicRouteTableWithChan invokes the iot.DeleteTopicRouteTable API asynchronously
func (client *Client) DeleteTopicRouteTableWithChan(request *DeleteTopicRouteTableRequest) (<-chan *DeleteTopicRouteTableResponse, <-chan error) {
	responseChan := make(chan *DeleteTopicRouteTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTopicRouteTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTopicRouteTableWithCallback invokes the iot.DeleteTopicRouteTable API asynchronously
func (client *Client) DeleteTopicRouteTableWithCallback(request *DeleteTopicRouteTableRequest, callback func(response *DeleteTopicRouteTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTopicRouteTableResponse
		var err error
		defer close(result)
		response, err = client.DeleteTopicRouteTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTopicRouteTableRequest is the request struct for api DeleteTopicRouteTable
type DeleteTopicRouteTableRequest struct {
	*requests.RpcRequest
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	DstTopic      *[]string `position:"Query" name:"DstTopic"  type:"Repeated"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	SrcTopic      string    `position:"Query" name:"SrcTopic"`
}

// DeleteTopicRouteTableResponse is the response struct for api DeleteTopicRouteTable
type DeleteTopicRouteTableResponse struct {
	*responses.BaseResponse
	RequestId     string                               `json:"RequestId" xml:"RequestId"`
	Success       bool                                 `json:"Success" xml:"Success"`
	Code          string                               `json:"Code" xml:"Code"`
	IsAllSucceed  bool                                 `json:"IsAllSucceed" xml:"IsAllSucceed"`
	ErrorMessage  string                               `json:"ErrorMessage" xml:"ErrorMessage"`
	FailureTopics FailureTopicsInDeleteTopicRouteTable `json:"FailureTopics" xml:"FailureTopics"`
}

// CreateDeleteTopicRouteTableRequest creates a request to invoke DeleteTopicRouteTable API
func CreateDeleteTopicRouteTableRequest() (request *DeleteTopicRouteTableRequest) {
	request = &DeleteTopicRouteTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteTopicRouteTable", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTopicRouteTableResponse creates a response to parse from DeleteTopicRouteTable response
func CreateDeleteTopicRouteTableResponse() (response *DeleteTopicRouteTableResponse) {
	response = &DeleteTopicRouteTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
