package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLicenseDeviceList invokes the iot.QueryLicenseDeviceList API synchronously
func (client *Client) QueryLicenseDeviceList(request *QueryLicenseDeviceListRequest) (response *QueryLicenseDeviceListResponse, err error) {
	response = CreateQueryLicenseDeviceListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLicenseDeviceListWithChan invokes the iot.QueryLicenseDeviceList API asynchronously
func (client *Client) QueryLicenseDeviceListWithChan(request *QueryLicenseDeviceListRequest) (<-chan *QueryLicenseDeviceListResponse, <-chan error) {
	responseChan := make(chan *QueryLicenseDeviceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLicenseDeviceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLicenseDeviceListWithCallback invokes the iot.QueryLicenseDeviceList API asynchronously
func (client *Client) QueryLicenseDeviceListWithCallback(request *QueryLicenseDeviceListRequest, callback func(response *QueryLicenseDeviceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLicenseDeviceListResponse
		var err error
		defer close(result)
		response, err = client.QueryLicenseDeviceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLicenseDeviceListRequest is the request struct for api QueryLicenseDeviceList
type QueryLicenseDeviceListRequest struct {
	*requests.RpcRequest
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	PageId        requests.Integer `position:"Query" name:"PageId"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	LicenseCode   string           `position:"Query" name:"LicenseCode"`
}

// QueryLicenseDeviceListResponse is the response struct for api QueryLicenseDeviceList
type QueryLicenseDeviceListResponse struct {
	*responses.BaseResponse
	RequestId    string                       `json:"RequestId" xml:"RequestId"`
	Success      bool                         `json:"Success" xml:"Success"`
	Code         string                       `json:"Code" xml:"Code"`
	ErrorMessage string                       `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryLicenseDeviceList `json:"Data" xml:"Data"`
}

// CreateQueryLicenseDeviceListRequest creates a request to invoke QueryLicenseDeviceList API
func CreateQueryLicenseDeviceListRequest() (request *QueryLicenseDeviceListRequest) {
	request = &QueryLicenseDeviceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryLicenseDeviceList", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryLicenseDeviceListResponse creates a response to parse from QueryLicenseDeviceList response
func CreateQueryLicenseDeviceListResponse() (response *QueryLicenseDeviceListResponse) {
	response = &QueryLicenseDeviceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
