package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFaceUser invokes the linkvisual.AddFaceUser API synchronously
func (client *Client) AddFaceUser(request *AddFaceUserRequest) (response *AddFaceUserResponse, err error) {
	response = CreateAddFaceUserResponse()
	err = client.DoAction(request, response)
	return
}

// AddFaceUserWithChan invokes the linkvisual.AddFaceUser API asynchronously
func (client *Client) AddFaceUserWithChan(request *AddFaceUserRequest) (<-chan *AddFaceUserResponse, <-chan error) {
	responseChan := make(chan *AddFaceUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFaceUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFaceUserWithCallback invokes the linkvisual.AddFaceUser API asynchronously
func (client *Client) AddFaceUserWithCallback(request *AddFaceUserRequest, callback func(response *AddFaceUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFaceUserResponse
		var err error
		defer close(result)
		response, err = client.AddFaceUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFaceUserRequest is the request struct for api AddFaceUser
type AddFaceUserRequest struct {
	*requests.RpcRequest
	IsolationId  string `position:"Query" name:"IsolationId"`
	CustomUserId string `position:"Query" name:"CustomUserId"`
	Params       string `position:"Query" name:"Params"`
	FacePicUrl   string `position:"Query" name:"FacePicUrl"`
	ApiProduct   string `position:"Body" name:"ApiProduct"`
	Name         string `position:"Query" name:"Name"`
	ApiRevision  string `position:"Body" name:"ApiRevision"`
}

// AddFaceUserResponse is the response struct for api AddFaceUser
type AddFaceUserResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateAddFaceUserRequest creates a request to invoke AddFaceUser API
func CreateAddFaceUserRequest() (request *AddFaceUserRequest) {
	request = &AddFaceUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "AddFaceUser", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFaceUserResponse creates a response to parse from AddFaceUser response
func CreateAddFaceUserResponse() (response *AddFaceUserResponse) {
	response = &AddFaceUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
