package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceAllDeviceGroup invokes the linkvisual.QueryFaceAllDeviceGroup API synchronously
func (client *Client) QueryFaceAllDeviceGroup(request *QueryFaceAllDeviceGroupRequest) (response *QueryFaceAllDeviceGroupResponse, err error) {
	response = CreateQueryFaceAllDeviceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceAllDeviceGroupWithChan invokes the linkvisual.QueryFaceAllDeviceGroup API asynchronously
func (client *Client) QueryFaceAllDeviceGroupWithChan(request *QueryFaceAllDeviceGroupRequest) (<-chan *QueryFaceAllDeviceGroupResponse, <-chan error) {
	responseChan := make(chan *QueryFaceAllDeviceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceAllDeviceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceAllDeviceGroupWithCallback invokes the linkvisual.QueryFaceAllDeviceGroup API asynchronously
func (client *Client) QueryFaceAllDeviceGroupWithCallback(request *QueryFaceAllDeviceGroupRequest, callback func(response *QueryFaceAllDeviceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceAllDeviceGroupResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceAllDeviceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceAllDeviceGroupRequest is the request struct for api QueryFaceAllDeviceGroup
type QueryFaceAllDeviceGroupRequest struct {
	*requests.RpcRequest
	IsolationId   string           `position:"Query" name:"IsolationId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	PageNo        requests.Integer `position:"Query" name:"PageNo"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QueryFaceAllDeviceGroupResponse is the response struct for api QueryFaceAllDeviceGroup
type QueryFaceAllDeviceGroupResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceAllDeviceGroupRequest creates a request to invoke QueryFaceAllDeviceGroup API
func CreateQueryFaceAllDeviceGroupRequest() (request *QueryFaceAllDeviceGroupRequest) {
	request = &QueryFaceAllDeviceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceAllDeviceGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceAllDeviceGroupResponse creates a response to parse from QueryFaceAllDeviceGroup response
func CreateQueryFaceAllDeviceGroupResponse() (response *QueryFaceAllDeviceGroupResponse) {
	response = &QueryFaceAllDeviceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
