package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddNodeToGroup invokes the linkwan.AddNodeToGroup API synchronously
func (client *Client) AddNodeToGroup(request *AddNodeToGroupRequest) (response *AddNodeToGroupResponse, err error) {
	response = CreateAddNodeToGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddNodeToGroupWithChan invokes the linkwan.AddNodeToGroup API asynchronously
func (client *Client) AddNodeToGroupWithChan(request *AddNodeToGroupRequest) (<-chan *AddNodeToGroupResponse, <-chan error) {
	responseChan := make(chan *AddNodeToGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddNodeToGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddNodeToGroupWithCallback invokes the linkwan.AddNodeToGroup API asynchronously
func (client *Client) AddNodeToGroupWithCallback(request *AddNodeToGroupRequest, callback func(response *AddNodeToGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddNodeToGroupResponse
		var err error
		defer close(result)
		response, err = client.AddNodeToGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddNodeToGroupRequest is the request struct for api AddNodeToGroup
type AddNodeToGroupRequest struct {
	*requests.RpcRequest
	PinCode     string `position:"Query" name:"PinCode"`
	DevEui      string `position:"Query" name:"DevEui"`
	NodeGroupId string `position:"Query" name:"NodeGroupId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// AddNodeToGroupResponse is the response struct for api AddNodeToGroup
type AddNodeToGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAddNodeToGroupRequest creates a request to invoke AddNodeToGroup API
func CreateAddNodeToGroupRequest() (request *AddNodeToGroupRequest) {
	request = &AddNodeToGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "AddNodeToGroup", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddNodeToGroupResponse creates a response to parse from AddNodeToGroup response
func CreateAddNodeToGroupResponse() (response *AddNodeToGroupResponse) {
	response = &AddNodeToGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
