package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLivePackageConfig invokes the live.DescribeLivePackageConfig API synchronously
func (client *Client) DescribeLivePackageConfig(request *DescribeLivePackageConfigRequest) (response *DescribeLivePackageConfigResponse, err error) {
	response = CreateDescribeLivePackageConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLivePackageConfigWithChan invokes the live.DescribeLivePackageConfig API asynchronously
func (client *Client) DescribeLivePackageConfigWithChan(request *DescribeLivePackageConfigRequest) (<-chan *DescribeLivePackageConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLivePackageConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLivePackageConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLivePackageConfigWithCallback invokes the live.DescribeLivePackageConfig API asynchronously
func (client *Client) DescribeLivePackageConfigWithCallback(request *DescribeLivePackageConfigRequest, callback func(response *DescribeLivePackageConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLivePackageConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLivePackageConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLivePackageConfigRequest is the request struct for api DescribeLivePackageConfig
type DescribeLivePackageConfigRequest struct {
	*requests.RpcRequest
	PageNum    requests.Integer `position:"Query" name:"PageNum"`
	AppName    string           `position:"Query" name:"AppName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StreamName string           `position:"Query" name:"StreamName"`
	Order      string           `position:"Query" name:"Order"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLivePackageConfigResponse is the response struct for api DescribeLivePackageConfig
type DescribeLivePackageConfigResponse struct {
	*responses.BaseResponse
	Order                 string                `json:"Order" xml:"Order"`
	PageNum               int                   `json:"PageNum" xml:"PageNum"`
	PageSize              int                   `json:"PageSize" xml:"PageSize"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	TotalNum              int                   `json:"TotalNum" xml:"TotalNum"`
	TotalPage             int                   `json:"TotalPage" xml:"TotalPage"`
	LivePackageConfigList LivePackageConfigList `json:"LivePackageConfigList" xml:"LivePackageConfigList"`
}

// CreateDescribeLivePackageConfigRequest creates a request to invoke DescribeLivePackageConfig API
func CreateDescribeLivePackageConfigRequest() (request *DescribeLivePackageConfigRequest) {
	request = &DescribeLivePackageConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLivePackageConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLivePackageConfigResponse creates a response to parse from DescribeLivePackageConfig response
func CreateDescribeLivePackageConfigResponse() (response *DescribeLivePackageConfigResponse) {
	response = &DescribeLivePackageConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
