package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcMPUEventSub invokes the live.DescribeRtcMPUEventSub API synchronously
func (client *Client) DescribeRtcMPUEventSub(request *DescribeRtcMPUEventSubRequest) (response *DescribeRtcMPUEventSubResponse, err error) {
	response = CreateDescribeRtcMPUEventSubResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcMPUEventSubWithChan invokes the live.DescribeRtcMPUEventSub API asynchronously
func (client *Client) DescribeRtcMPUEventSubWithChan(request *DescribeRtcMPUEventSubRequest) (<-chan *DescribeRtcMPUEventSubResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcMPUEventSubResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcMPUEventSub(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcMPUEventSubWithCallback invokes the live.DescribeRtcMPUEventSub API asynchronously
func (client *Client) DescribeRtcMPUEventSubWithCallback(request *DescribeRtcMPUEventSubRequest, callback func(response *DescribeRtcMPUEventSubResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcMPUEventSubResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcMPUEventSub(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcMPUEventSubRequest is the request struct for api DescribeRtcMPUEventSub
type DescribeRtcMPUEventSubRequest struct {
	*requests.RpcRequest
	AppId string `position:"Query" name:"AppId"`
}

// DescribeRtcMPUEventSubResponse is the response struct for api DescribeRtcMPUEventSub
type DescribeRtcMPUEventSubResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	SubInfo   SubInfo `json:"SubInfo" xml:"SubInfo"`
}

// CreateDescribeRtcMPUEventSubRequest creates a request to invoke DescribeRtcMPUEventSub API
func CreateDescribeRtcMPUEventSubRequest() (request *DescribeRtcMPUEventSubRequest) {
	request = &DescribeRtcMPUEventSubRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeRtcMPUEventSub", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcMPUEventSubResponse creates a response to parse from DescribeRtcMPUEventSub response
func CreateDescribeRtcMPUEventSubResponse() (response *DescribeRtcMPUEventSubResponse) {
	response = &DescribeRtcMPUEventSubResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
